/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.processing.streaming.token.store.jdbc;

import jakarta.annotation.Nonnull;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import org.axonframework.common.BuilderUtils;
import org.axonframework.messaging.eventhandling.processing.streaming.token.store.jdbc.TokenSchema;

public record JdbcTokenStoreConfiguration(@Nonnull TokenSchema schema, @Nonnull TemporalAmount claimTimeout, @Nonnull String nodeId) {
    public static final JdbcTokenStoreConfiguration DEFAULT = new JdbcTokenStoreConfiguration(new TokenSchema(), Duration.ofSeconds(10L), ManagementFactory.getRuntimeMXBean().getName());

    public JdbcTokenStoreConfiguration {
        BuilderUtils.assertNonEmpty(nodeId, "The nodeId may not be empty.");
    }

    public JdbcTokenStoreConfiguration schema(@Nonnull TokenSchema schema) {
        BuilderUtils.assertNonNull(schema, "The TokenSchema may not be null.");
        return new JdbcTokenStoreConfiguration(schema, this.claimTimeout, this.nodeId);
    }

    public JdbcTokenStoreConfiguration claimTimeout(@Nonnull TemporalAmount claimTimeout) {
        BuilderUtils.assertNonNull(claimTimeout, "The claim timeout may not be null");
        return new JdbcTokenStoreConfiguration(this.schema, claimTimeout, this.nodeId);
    }

    public JdbcTokenStoreConfiguration nodeId(@Nonnull String nodeId) {
        BuilderUtils.assertNonEmpty(nodeId, "The nodeId may not be null or empty.");
        return new JdbcTokenStoreConfiguration(this.schema, this.claimTimeout, nodeId);
    }
}

