/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.core.DefaultMessageDispatchInterceptorChain;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageDispatchInterceptor;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.EventSink;

@Internal
public class InterceptingEventSink
implements EventSink {
    public static final int DECORATION_ORDER = -2147483548;
    private final EventSink delegate;
    private final List<MessageDispatchInterceptor<? super EventMessage>> interceptors;
    private final InterceptingPublisher interceptingPublisher;

    public InterceptingEventSink(@Nonnull EventSink delegate, @Nonnull List<MessageDispatchInterceptor<? super EventMessage>> interceptors) {
        this.delegate = Objects.requireNonNull(delegate, "The EventSink may not be null.");
        this.interceptors = Objects.requireNonNull(interceptors, "The dispatch interception must not be null.");
        this.interceptingPublisher = new InterceptingPublisher(interceptors, this::publishEvent);
    }

    @Override
    public CompletableFuture<Void> publish(@Nullable ProcessingContext context, @Nonnull List<EventMessage> events) {
        return this.interceptingPublisher.interceptAndPublish(events, context);
    }

    private MessageStream.Empty<Message> publishEvent(@Nonnull EventMessage event, @Nullable ProcessingContext context) {
        return MessageStream.fromFuture(this.delegate.publish(context, event).thenApply(v -> null)).ignoreEntries();
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf(this.delegate);
        descriptor.describeProperty("dispatchInterceptors", this.interceptors);
    }

    private static class InterceptingPublisher {
        private final DefaultMessageDispatchInterceptorChain<? super EventMessage> interceptorChain;

        private InterceptingPublisher(List<MessageDispatchInterceptor<? super EventMessage>> interceptors, BiFunction<? super EventMessage, ProcessingContext, MessageStream<?>> publisher) {
            this.interceptorChain = new DefaultMessageDispatchInterceptorChain<EventMessage>(interceptors, publisher);
        }

        private CompletableFuture<Void> interceptAndPublish(@Nonnull List<EventMessage> events, @Nullable ProcessingContext context) {
            MessageStream<Message> resultStream = MessageStream.empty();
            for (EventMessage event : events) {
                resultStream = resultStream.concatWith(this.interceptorChain.proceed(event, context).cast());
            }
            return resultStream.ignoreEntries().asCompletableFuture().thenApply(v -> null);
        }
    }
}

