/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.retry;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.function.Predicate;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.retry.RetryPolicy;

public class FilteringRetryPolicy
implements RetryPolicy {
    private final RetryPolicy delegate;
    private final Predicate<Throwable> retryableErrorPredicate;

    public FilteringRetryPolicy(RetryPolicy delegate, Predicate<Throwable> retryableErrorPredicate) {
        this.delegate = delegate;
        this.retryableErrorPredicate = retryableErrorPredicate;
    }

    @Override
    public RetryPolicy.Outcome defineFor(@Nonnull Message message, @Nonnull Throwable cause, @Nonnull List<Class<? extends Throwable>[]> previousFailures) {
        if (this.retryableErrorPredicate.test(cause)) {
            return this.delegate.defineFor(message, cause, previousFailures);
        }
        return RetryPolicy.Outcome.doNotReschedule();
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf(this.delegate);
        descriptor.describeProperty("filter", this.retryableErrorPredicate.toString());
    }
}

