/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Consumer;
import org.axonframework.common.configuration.ApplicationConfigurer;
import org.axonframework.common.configuration.AxonConfiguration;
import org.axonframework.common.configuration.ComponentBuilder;
import org.axonframework.common.configuration.ComponentRegistry;
import org.axonframework.common.configuration.DefaultAxonApplication;
import org.axonframework.common.configuration.LifecycleRegistry;
import org.axonframework.common.configuration.Module;
import org.axonframework.common.configuration.ModuleBuilder;
import org.axonframework.messaging.commandhandling.CommandBus;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.messaging.commandhandling.configuration.CommandHandlingModule;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageDispatchInterceptor;
import org.axonframework.messaging.core.MessageHandlerInterceptor;
import org.axonframework.messaging.core.MessageTypeResolver;
import org.axonframework.messaging.core.annotation.ParameterResolverFactory;
import org.axonframework.messaging.core.configuration.MessagingConfigurationDefaults;
import org.axonframework.messaging.core.configuration.reflection.ParameterResolverFactoryUtils;
import org.axonframework.messaging.core.correlation.CorrelationDataProvider;
import org.axonframework.messaging.core.correlation.CorrelationDataProviderRegistry;
import org.axonframework.messaging.core.interception.DispatchInterceptorRegistry;
import org.axonframework.messaging.core.interception.HandlerInterceptorRegistry;
import org.axonframework.messaging.core.unitofwork.UnitOfWorkFactory;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.EventSink;
import org.axonframework.messaging.eventhandling.configuration.EventBusConfigurationDefaults;
import org.axonframework.messaging.eventhandling.configuration.EventProcessingConfigurer;
import org.axonframework.messaging.monitoring.MessageMonitor;
import org.axonframework.messaging.monitoring.configuration.MessageMonitorRegistry;
import org.axonframework.messaging.queryhandling.QueryBus;
import org.axonframework.messaging.queryhandling.QueryMessage;
import org.axonframework.messaging.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.messaging.queryhandling.configuration.QueryHandlingModule;

public class MessagingConfigurer
implements ApplicationConfigurer {
    private final ApplicationConfigurer delegate;
    private final EventProcessingConfigurer eventProcessing;

    private MessagingConfigurer(@Nonnull ApplicationConfigurer delegate) {
        this.delegate = Objects.requireNonNull(delegate, "The Application Configurer cannot be null.");
        this.eventProcessing = new EventProcessingConfigurer(this);
    }

    public static MessagingConfigurer enhance(@Nonnull ApplicationConfigurer applicationConfigurer) {
        return new MessagingConfigurer(applicationConfigurer).componentRegistry(cr -> cr.registerEnhancer(new EventBusConfigurationDefaults()).registerEnhancer(new MessagingConfigurationDefaults()));
    }

    public static MessagingConfigurer create() {
        return MessagingConfigurer.enhance(new DefaultAxonApplication());
    }

    public MessagingConfigurer registerMessageTypeResolver(@Nonnull ComponentBuilder<MessageTypeResolver> messageTypeResolverFactory) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerComponent(MessageTypeResolver.class, messageTypeResolverFactory));
        return this;
    }

    public MessagingConfigurer registerCommandBus(@Nonnull ComponentBuilder<CommandBus> commandBusBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerComponent(CommandBus.class, commandBusBuilder));
        return this;
    }

    public MessagingConfigurer registerEventSink(@Nonnull ComponentBuilder<EventSink> eventSinkBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerComponent(EventSink.class, eventSinkBuilder));
        return this;
    }

    public MessagingConfigurer registerQueryBus(@Nonnull ComponentBuilder<QueryBus> queryBusBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerComponent(QueryBus.class, queryBusBuilder));
        return this;
    }

    public MessagingConfigurer registerParameterResolverFactory(@Nonnull ComponentBuilder<ParameterResolverFactory> parameterResolverFactoryBuilder) {
        this.delegate.componentRegistry((ComponentRegistry registry) -> ParameterResolverFactoryUtils.registerToComponentRegistry(registry, parameterResolverFactoryBuilder::build));
        return this;
    }

    public MessagingConfigurer registerUnitOfWorkFactory(@Nonnull ComponentBuilder<UnitOfWorkFactory> unitOfWorkFactoryBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerComponent(UnitOfWorkFactory.class, unitOfWorkFactoryBuilder));
        return this;
    }

    public MessagingConfigurer registerCorrelationDataProvider(@Nonnull ComponentBuilder<CorrelationDataProvider> providerBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(CorrelationDataProviderRegistry.class, 0, (config, name, delegate) -> delegate.registerProvider(providerBuilder)));
        return this;
    }

    public MessagingConfigurer registerDispatchInterceptor(@Nonnull ComponentBuilder<MessageDispatchInterceptor<Message>> interceptorBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(DispatchInterceptorRegistry.class, 0, (config, name, delegate) -> delegate.registerInterceptor(interceptorBuilder)));
        return this;
    }

    public MessagingConfigurer registerCommandDispatchInterceptor(@Nonnull ComponentBuilder<MessageDispatchInterceptor<? super CommandMessage>> interceptorBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(DispatchInterceptorRegistry.class, 0, (config, name, delegate) -> delegate.registerCommandInterceptor(interceptorBuilder)));
        return this;
    }

    public MessagingConfigurer registerEventDispatchInterceptor(@Nonnull ComponentBuilder<MessageDispatchInterceptor<? super EventMessage>> interceptorBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(DispatchInterceptorRegistry.class, 0, (config, name, delegate) -> delegate.registerEventInterceptor(interceptorBuilder)));
        return this;
    }

    public MessagingConfigurer registerQueryDispatchInterceptor(@Nonnull ComponentBuilder<MessageDispatchInterceptor<? super QueryMessage>> interceptorBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(DispatchInterceptorRegistry.class, 0, (config, name, delegate) -> delegate.registerQueryInterceptor(interceptorBuilder)));
        return this;
    }

    public MessagingConfigurer registerMessageHandlerInterceptor(@Nonnull ComponentBuilder<MessageHandlerInterceptor<Message>> interceptorBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(HandlerInterceptorRegistry.class, 0, (config, name, delegate) -> delegate.registerInterceptor(interceptorBuilder)));
        return this;
    }

    public MessagingConfigurer registerCommandHandlerInterceptor(@Nonnull ComponentBuilder<MessageHandlerInterceptor<? super CommandMessage>> interceptorBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(HandlerInterceptorRegistry.class, 0, (config, name, delegate) -> delegate.registerCommandInterceptor(interceptorBuilder)));
        return this;
    }

    public MessagingConfigurer registerEventHandlerInterceptor(@Nonnull ComponentBuilder<MessageHandlerInterceptor<? super EventMessage>> interceptorBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(HandlerInterceptorRegistry.class, 0, (config, name, delegate) -> delegate.registerEventInterceptor(interceptorBuilder)));
        return this;
    }

    public MessagingConfigurer registerQueryHandlerInterceptor(@Nonnull ComponentBuilder<MessageHandlerInterceptor<? super QueryMessage>> interceptorBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(HandlerInterceptorRegistry.class, 0, (config, name, delegate) -> delegate.registerQueryInterceptor(interceptorBuilder)));
        return this;
    }

    @Nonnull
    public MessagingConfigurer registerCommandHandlingModule(@Nonnull ModuleBuilder<CommandHandlingModule> moduleBuilder) {
        Objects.requireNonNull(moduleBuilder, "The moduleBuilder cannot be null.");
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerModule((Module)moduleBuilder.build()));
        return this;
    }

    @Nonnull
    public MessagingConfigurer registerQueryHandlingModule(@Nonnull ModuleBuilder<QueryHandlingModule> moduleBuilder) {
        Objects.requireNonNull(moduleBuilder, "The moduleBuilder cannot be null.");
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerModule((Module)moduleBuilder.build()));
        return this;
    }

    public MessagingConfigurer registerMessageMonitor(@Nonnull ComponentBuilder<MessageMonitor<Message>> messageMonitorBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(MessageMonitorRegistry.class, 0, (config, name, delegate) -> delegate.registerMonitor(messageMonitorBuilder)));
        return this;
    }

    public MessagingConfigurer registerCommandMonitor(@Nonnull ComponentBuilder<MessageMonitor<? super CommandMessage>> messageMonitorBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(MessageMonitorRegistry.class, 0, (config, name, delegate) -> delegate.registerCommandMonitor(messageMonitorBuilder)));
        return this;
    }

    public MessagingConfigurer registerEventMonitor(@Nonnull ComponentBuilder<MessageMonitor<? super EventMessage>> messageMonitorBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(MessageMonitorRegistry.class, 0, (config, name, delegate) -> delegate.registerEventMonitor(messageMonitorBuilder)));
        return this;
    }

    public MessagingConfigurer registerQueryMonitor(@Nonnull ComponentBuilder<MessageMonitor<? super QueryMessage>> messageMonitorBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(MessageMonitorRegistry.class, 0, (config, name, delegate) -> delegate.registerQueryMonitor(messageMonitorBuilder)));
        return this;
    }

    public MessagingConfigurer registerSubscriptionQueryUpdateMonitor(@Nonnull ComponentBuilder<MessageMonitor<? super SubscriptionQueryUpdateMessage>> messageMonitorBuilder) {
        this.delegate.componentRegistry((ComponentRegistry cr) -> cr.registerDecorator(MessageMonitorRegistry.class, 0, (config, name, delegate) -> delegate.registerSubscriptionQueryUpdateMonitor(messageMonitorBuilder)));
        return this;
    }

    @Override
    public MessagingConfigurer componentRegistry(@Nonnull Consumer<ComponentRegistry> componentRegistrar) {
        this.delegate.componentRegistry(Objects.requireNonNull(componentRegistrar, "The configure task must no be null."));
        return this;
    }

    @Override
    public MessagingConfigurer lifecycleRegistry(@Nonnull Consumer<LifecycleRegistry> lifecycleRegistrar) {
        this.delegate.lifecycleRegistry(Objects.requireNonNull(lifecycleRegistrar, "The lifecycle registrar must not be null."));
        return this;
    }

    public MessagingConfigurer eventProcessing(@Nonnull Consumer<EventProcessingConfigurer> configurerTask) {
        Objects.requireNonNull(configurerTask, "The configurerTask may not be null");
        configurerTask.accept(this.eventProcessing);
        return this;
    }

    @Override
    public AxonConfiguration build() {
        this.eventProcessing.build();
        return this.delegate.build();
    }
}

