/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.annotation;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.WeakHashMap;
import org.axonframework.messaging.core.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.core.annotation.MultiHandlerEnhancerDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClasspathHandlerEnhancerDefinition {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathHandlerEnhancerDefinition.class);
    private static final Object MONITOR = new Object();
    private static final Map<ClassLoader, WeakReference<MultiHandlerEnhancerDefinition>> FACTORIES = new WeakHashMap<ClassLoader, WeakReference<MultiHandlerEnhancerDefinition>>();

    private ClasspathHandlerEnhancerDefinition() {
    }

    public static MultiHandlerEnhancerDefinition forClass(Class<?> clazz) {
        return ClasspathHandlerEnhancerDefinition.forClassLoader(clazz == null ? null : clazz.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiHandlerEnhancerDefinition forClassLoader(ClassLoader classLoader) {
        Object object = MONITOR;
        synchronized (object) {
            if (!FACTORIES.containsKey(classLoader)) {
                MultiHandlerEnhancerDefinition enhancerDefinition = MultiHandlerEnhancerDefinition.ordered(ClasspathHandlerEnhancerDefinition.findDelegates(classLoader));
                FACTORIES.put(classLoader, new WeakReference<MultiHandlerEnhancerDefinition>(enhancerDefinition));
                return enhancerDefinition;
            }
            MultiHandlerEnhancerDefinition enhancerDefinition = (MultiHandlerEnhancerDefinition)FACTORIES.get(classLoader).get();
            if (enhancerDefinition == null) {
                enhancerDefinition = MultiHandlerEnhancerDefinition.ordered(ClasspathHandlerEnhancerDefinition.findDelegates(classLoader));
                FACTORIES.put(classLoader, new WeakReference<MultiHandlerEnhancerDefinition>(enhancerDefinition));
            }
            return enhancerDefinition;
        }
    }

    private static MultiHandlerEnhancerDefinition findDelegates(ClassLoader classLoader) {
        Iterator<HandlerEnhancerDefinition> iterator = ServiceLoader.load(HandlerEnhancerDefinition.class, classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader).iterator();
        ArrayList<HandlerEnhancerDefinition> enhancers = new ArrayList<HandlerEnhancerDefinition>();
        while (iterator.hasNext()) {
            try {
                HandlerEnhancerDefinition factory = iterator.next();
                enhancers.add(factory);
            }
            catch (ServiceConfigurationError e) {
                LOGGER.info("HandlerEnhancerDefinition instance ignored, as one of the required classes is not availableon the classpath: {}", (Object)e.getMessage());
            }
            catch (NoClassDefFoundError e) {
                LOGGER.info("HandlerEnhancerDefinition instance ignored. It relies on a class that cannot be found: {}", (Object)e.getMessage());
            }
        }
        return new MultiHandlerEnhancerDefinition(enhancers);
    }
}

