/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.axonframework.common.Assert;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.StringUtils;

public record QualifiedName(@Nonnull String name) {
    private static final String DELIMITER = ".";

    public QualifiedName {
        Assert.assertThat(Objects.requireNonNull(name, "The given name is unsupported because it is null."), StringUtils::nonEmpty, () -> new IllegalArgumentException("The given name is unsupported because it is empty."));
    }

    public QualifiedName(String namespace, @Nonnull String localName) {
        this(QualifiedName.combineNames(namespace, localName));
    }

    public QualifiedName(@Nonnull Class<?> clazz) {
        this(((Class)ReflectionUtils.resolvePrimitiveWrapperTypeIfPrimitive(Objects.requireNonNull(clazz, "The given Class cannot be null."))).getName());
    }

    private static String combineNames(String namespace, String localName) {
        Assert.assertThat(Objects.requireNonNull(localName, "The given local name [" + localName + "] is unsupported because it is null."), StringUtils::nonEmptyOrNull, () -> new IllegalArgumentException("The given local name [" + localName + "] is unsupported because it is empty."));
        return StringUtils.nonEmptyOrNull(namespace) ? namespace + DELIMITER + localName : localName;
    }

    @Nullable
    public String namespace() {
        int lastDelimiterIndex = this.name.lastIndexOf(DELIMITER);
        return lastDelimiterIndex != -1 ? this.name.substring(0, lastDelimiterIndex) : null;
    }

    @Nonnull
    public String localName() {
        return this.name.substring(this.name.lastIndexOf(DELIMITER) + 1);
    }

    @Override
    public String toString() {
        return this.name;
    }

    public String fullName() {
        return this.name;
    }
}

