/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import org.axonframework.common.annotation.Internal;
import org.axonframework.messaging.core.EmptyContext;
import org.axonframework.messaging.core.SimpleContext;

public interface Context {
    public static <T> Context with(ResourceKey<T> key, T value) {
        return new SimpleContext(key, value);
    }

    public static Context empty() {
        return EmptyContext.INSTANCE;
    }

    public boolean containsResource(@Nonnull ResourceKey<?> var1);

    public <T> T getResource(@Nonnull ResourceKey<T> var1);

    public <T> Context withResource(@Nonnull ResourceKey<T> var1, @Nonnull T var2);

    @Internal
    public Map<ResourceKey<?>, Object> resources();

    public static final class ResourceKey<T> {
        private static final String RESOURCE_KEY_PREFIX = "ResourceKey@";
        private final String identity;
        private final String label;

        private ResourceKey(@Nullable String label) {
            this.label = label;
            String keyId = RESOURCE_KEY_PREFIX + Integer.toHexString(System.identityHashCode(this));
            this.identity = label == null || label.isBlank() ? keyId : keyId + "[" + label + "]";
        }

        public static <T> ResourceKey<T> withLabel(@Nullable String label) {
            return new ResourceKey<T>(label);
        }

        public String label() {
            return this.label;
        }

        public String toString() {
            return this.identity;
        }
    }
}

