/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling.interceptors;

import jakarta.annotation.Nonnull;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.axonframework.common.annotations.Internal;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptorChain;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.queryhandling.QueryHandler;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;

@Internal
public class QueryMessageHandlerInterceptorChain
implements MessageHandlerInterceptorChain<QueryMessage> {
    private final QueryHandler interceptingHandler;

    public QueryMessageHandlerInterceptorChain(@Nonnull List<MessageHandlerInterceptor<? super QueryMessage>> interceptors, @Nonnull QueryHandler queryHandler) {
        Iterator<MessageHandlerInterceptor<? super QueryMessage>> interceptorIterator = new LinkedList<MessageHandlerInterceptor<? super QueryMessage>>(interceptors).descendingIterator();
        QueryHandler handler = Objects.requireNonNull(queryHandler, "The Query Handler may not be null.");
        while (interceptorIterator.hasNext()) {
            handler = new InterceptingHandler(interceptorIterator.next(), handler);
        }
        this.interceptingHandler = handler;
    }

    @Override
    @Nonnull
    public MessageStream<?> proceed(@Nonnull QueryMessage query, @Nonnull ProcessingContext context) {
        try {
            return this.interceptingHandler.handle(query, context);
        }
        catch (Exception e) {
            return MessageStream.failed(e);
        }
    }

    private record InterceptingHandler(MessageHandlerInterceptor<? super QueryMessage> interceptor, QueryHandler next) implements QueryHandler,
    MessageHandlerInterceptorChain<QueryMessage>
    {
        @Override
        @Nonnull
        public MessageStream<QueryResponseMessage> handle(@Nonnull QueryMessage query, @Nonnull ProcessingContext context) {
            return this.interceptor.interceptOnHandle(query, context, this);
        }

        @Override
        @Nonnull
        public MessageStream<?> proceed(@Nonnull QueryMessage query, @Nonnull ProcessingContext context) {
            return this.next.handle(query, context);
        }
    }
}

