/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling.interceptors;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.DefaultMessageDispatchInterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryHandler;
import org.axonframework.queryhandling.QueryHandlerName;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.queryhandling.interceptors.QueryMessageHandlerInterceptorChain;

public class InterceptingQueryBus
implements QueryBus {
    public static final int DECORATION_ORDER = -2147483548;
    private final QueryBus delegate;
    private final List<MessageHandlerInterceptor<? super QueryMessage>> handlerInterceptors;
    private final List<MessageDispatchInterceptor<? super QueryMessage>> dispatchInterceptors;
    private final List<MessageDispatchInterceptor<? super SubscriptionQueryUpdateMessage>> updateDispatchInterceptors;
    private final InterceptingDispatcher interceptingDispatcher;
    private final InterceptingResponseUpdateDispatcher interceptingResponseUpdateDispatcher;

    public InterceptingQueryBus(@Nonnull QueryBus delegate, @Nonnull List<MessageHandlerInterceptor<? super QueryMessage>> handlerInterceptors, @Nonnull List<MessageDispatchInterceptor<? super QueryMessage>> dispatchInterceptors, @Nonnull List<MessageDispatchInterceptor<? super SubscriptionQueryUpdateMessage>> updateDispatchInterceptors) {
        this.delegate = Objects.requireNonNull(delegate, "The query bus delegate must not be null.");
        this.handlerInterceptors = new ArrayList<MessageHandlerInterceptor<? super QueryMessage>>((Collection)Objects.requireNonNull(handlerInterceptors, "The handler interceptors must not be null."));
        this.dispatchInterceptors = new ArrayList<MessageDispatchInterceptor<? super QueryMessage>>((Collection)Objects.requireNonNull(dispatchInterceptors, "The dispatch interceptors must not be null."));
        this.updateDispatchInterceptors = new ArrayList<MessageDispatchInterceptor<? super SubscriptionQueryUpdateMessage>>((Collection)Objects.requireNonNull(updateDispatchInterceptors, "The update dispatch interceptors must not be null."));
        this.interceptingDispatcher = new InterceptingDispatcher(dispatchInterceptors, this::dispatchQuery);
        this.interceptingResponseUpdateDispatcher = new InterceptingResponseUpdateDispatcher(updateDispatchInterceptors);
    }

    @Override
    public InterceptingQueryBus subscribe(@Nonnull QueryHandlerName handlerName, @Nonnull QueryHandler queryHandler) {
        this.delegate.subscribe(handlerName, (QueryHandler)new InterceptingHandler(queryHandler, this.handlerInterceptors));
        return this;
    }

    @Override
    @Nonnull
    public MessageStream<QueryResponseMessage> query(@Nonnull QueryMessage query, @Nullable ProcessingContext context) {
        return this.interceptingDispatcher.interceptAndDispatch(query, context);
    }

    @Override
    @Nonnull
    public MessageStream<QueryResponseMessage> subscriptionQuery(@Nonnull SubscriptionQueryMessage query, @Nullable ProcessingContext context, int updateBufferSize) {
        return this.delegate.subscriptionQuery(query, context, updateBufferSize);
    }

    @Override
    @Nonnull
    public MessageStream<SubscriptionQueryUpdateMessage> subscribeToUpdates(@Nonnull SubscriptionQueryMessage query, int updateBufferSize) {
        return this.delegate.subscribeToUpdates(query, updateBufferSize);
    }

    @Override
    @Nonnull
    public CompletableFuture<Void> emitUpdate(@Nonnull Predicate<SubscriptionQueryMessage> filter, @Nonnull Supplier<SubscriptionQueryUpdateMessage> updateSupplier, @Nullable ProcessingContext context) {
        if (this.updateDispatchInterceptors.isEmpty()) {
            return this.delegate.emitUpdate(filter, updateSupplier, context);
        }
        try {
            SubscriptionQueryUpdateMessage update = updateSupplier.get();
            SubscriptionQueryUpdateMessage intercepted = this.interceptingResponseUpdateDispatcher.intercept(update, context);
            return this.delegate.emitUpdate(filter, () -> intercepted, context);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @Override
    @Nonnull
    public CompletableFuture<Void> completeSubscriptions(@Nonnull Predicate<SubscriptionQueryMessage> filter, @Nullable ProcessingContext context) {
        return this.delegate.completeSubscriptions(filter, context);
    }

    @Override
    @Nonnull
    public CompletableFuture<Void> completeSubscriptionsExceptionally(@Nonnull Predicate<SubscriptionQueryMessage> filter, @Nonnull Throwable cause, @Nullable ProcessingContext context) {
        return this.delegate.completeSubscriptionsExceptionally(filter, cause, context);
    }

    private MessageStream<?> dispatchQuery(@Nonnull Message message, @Nullable ProcessingContext processingContext) {
        if (!(message instanceof QueryMessage)) {
            throw new IllegalArgumentException("Unsupported message implementation: " + String.valueOf(message));
        }
        QueryMessage query = (QueryMessage)message;
        return this.delegate.query(query, processingContext);
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf(this.delegate);
        descriptor.describeProperty("handlerInterceptors", this.handlerInterceptors);
        descriptor.describeProperty("dispatchInterceptors", this.dispatchInterceptors);
        descriptor.describeProperty("updateDispatchInterceptors", this.updateDispatchInterceptors);
    }

    private static class InterceptingDispatcher {
        private final DefaultMessageDispatchInterceptorChain<? super QueryMessage> interceptorChain;

        private InterceptingDispatcher(List<MessageDispatchInterceptor<? super QueryMessage>> interceptors, BiFunction<? super QueryMessage, ProcessingContext, MessageStream<?>> dispatcher) {
            this.interceptorChain = new DefaultMessageDispatchInterceptorChain<QueryMessage>(interceptors, dispatcher);
        }

        private MessageStream<QueryResponseMessage> interceptAndDispatch(@Nonnull QueryMessage query, @Nullable ProcessingContext context) {
            return this.interceptorChain.proceed(query, context).cast();
        }
    }

    private static class InterceptingResponseUpdateDispatcher {
        private final DefaultMessageDispatchInterceptorChain<? super SubscriptionQueryUpdateMessage> interceptorChain;

        private InterceptingResponseUpdateDispatcher(List<MessageDispatchInterceptor<? super SubscriptionQueryUpdateMessage>> interceptors) {
            BiFunction<SubscriptionQueryUpdateMessage, ProcessingContext, MessageStream> dispatcher = (message, context) -> MessageStream.just(message).cast();
            this.interceptorChain = new DefaultMessageDispatchInterceptorChain<SubscriptionQueryUpdateMessage>(interceptors, dispatcher);
        }

        private SubscriptionQueryUpdateMessage intercept(@Nonnull SubscriptionQueryUpdateMessage update, @Nullable ProcessingContext context) {
            MessageStream<?> intercepted = this.interceptorChain.proceed(update, context);
            return (SubscriptionQueryUpdateMessage)intercepted.first().asCompletableFuture().join().message();
        }
    }

    private static class InterceptingHandler
    implements QueryHandler {
        private final QueryMessageHandlerInterceptorChain interceptorChain;

        private InterceptingHandler(QueryHandler handler, List<MessageHandlerInterceptor<? super QueryMessage>> interceptors) {
            this.interceptorChain = new QueryMessageHandlerInterceptorChain(interceptors, handler);
        }

        @Override
        @Nonnull
        public MessageStream<QueryResponseMessage> handle(@Nonnull QueryMessage query, @Nonnull ProcessingContext context) {
            return this.interceptorChain.proceed(query, context).cast();
        }
    }
}

