/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling.distributed;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.Registration;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.conversion.MessageConverter;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.queryhandling.distributed.DelegatingQueryBusConnector;
import org.axonframework.queryhandling.distributed.QueryBusConnector;
import org.axonframework.serialization.Converter;

public class PayloadConvertingQueryBusConnector
extends DelegatingQueryBusConnector {
    private final MessageConverter converter;
    private final Class<?> targetType;

    public PayloadConvertingQueryBusConnector(@Nonnull QueryBusConnector delegate, @Nonnull MessageConverter converter, @Nonnull Class<?> targetType) {
        super(delegate);
        this.converter = Objects.requireNonNull(converter, "The converter must not be null.");
        this.targetType = Objects.requireNonNull(targetType, "The targetType must not be null.");
    }

    @Override
    @Nonnull
    public MessageStream<QueryResponseMessage> query(@Nonnull QueryMessage query, @Nullable ProcessingContext context) {
        return this.delegate.query((QueryMessage)query.withConvertedPayload((Class)this.targetType, (Converter)this.converter), context);
    }

    @Override
    @Nonnull
    public MessageStream<QueryResponseMessage> subscriptionQuery(@Nonnull SubscriptionQueryMessage query, @Nullable ProcessingContext context, int updateBufferSize) {
        return this.delegate.subscriptionQuery((SubscriptionQueryMessage)query.withConvertedPayload((Class)this.targetType, (Converter)this.converter), context, updateBufferSize);
    }

    @Override
    public void onIncomingQuery(final @Nonnull QueryBusConnector.Handler handler) {
        this.delegate.onIncomingQuery(new QueryBusConnector.Handler(){

            @Override
            public MessageStream<QueryResponseMessage> query(@Nonnull QueryMessage query) {
                return handler.query(query).mapMessage(rm -> rm.withConvertedPayload((Class)PayloadConvertingQueryBusConnector.this.targetType, (Converter)PayloadConvertingQueryBusConnector.this.converter));
            }

            @Override
            @Nonnull
            public Registration registerUpdateHandler(@Nonnull SubscriptionQueryMessage subscriptionQueryMessage, final @Nonnull QueryBusConnector.UpdateCallback updateCallback) {
                return handler.registerUpdateHandler(subscriptionQueryMessage, new QueryBusConnector.UpdateCallback(){

                    @Override
                    @Nonnull
                    public CompletableFuture<Void> sendUpdate(@Nonnull SubscriptionQueryUpdateMessage update) {
                        return updateCallback.sendUpdate((SubscriptionQueryUpdateMessage)update.withConvertedPayload((Class)PayloadConvertingQueryBusConnector.this.targetType, (Converter)PayloadConvertingQueryBusConnector.this.converter));
                    }

                    @Override
                    public CompletableFuture<Void> complete() {
                        return updateCallback.complete();
                    }

                    @Override
                    public CompletableFuture<Void> completeExceptionally(@Nonnull Throwable cause) {
                        return updateCallback.completeExceptionally(cause);
                    }
                });
            }
        });
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf(this.delegate);
        descriptor.describeProperty("converter", this.converter);
        descriptor.describeProperty("targetType", this.targetType);
    }
}

