/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.OptionalInt;
import org.axonframework.common.ObjectUtils;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDecorator;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.Metadata;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.serialization.Converter;

public class GenericQueryMessage
extends MessageDecorator
implements QueryMessage {
    private final MessageType responseType;
    private final Integer priority;

    public GenericQueryMessage(@Nonnull MessageType type, @Nullable Object payload, @Nonnull MessageType responseType) {
        this(new GenericMessage(type, payload, Metadata.emptyInstance()), responseType, null);
    }

    public GenericQueryMessage(@Nonnull Message delegate, @Nonnull MessageType responseType) {
        this(delegate, responseType, null);
    }

    public GenericQueryMessage(@Nonnull Message delegate, @Nonnull MessageType responseType, @Nullable Integer priority) {
        super(delegate);
        this.responseType = responseType;
        this.priority = priority;
    }

    @Override
    @Nonnull
    public MessageType responseType() {
        return this.responseType;
    }

    @Override
    @Nonnull
    public QueryMessage withMetadata(@Nonnull Map<String, String> metadata) {
        return new GenericQueryMessage(this.delegate().withMetadata(metadata), this.responseType, this.priority);
    }

    @Override
    @Nonnull
    public QueryMessage andMetadata(@Nonnull Map<String, String> metadata) {
        return new GenericQueryMessage(this.delegate().andMetadata(metadata), this.responseType, this.priority);
    }

    @Override
    @Nonnull
    public QueryMessage withConvertedPayload(@Nonnull Type type, @Nonnull Converter converter) {
        Object convertedPayload = this.payloadAs(type, converter);
        if (ObjectUtils.nullSafeTypeOf(convertedPayload).isAssignableFrom(this.payloadType())) {
            return this;
        }
        Message delegate = this.delegate();
        GenericMessage converted = new GenericMessage(delegate.identifier(), delegate.type(), convertedPayload, (Map<String, String>)delegate.metadata());
        return new GenericQueryMessage(converted, this.responseType, this.priority);
    }

    @Override
    public OptionalInt priority() {
        return this.priority != null ? OptionalInt.of(this.priority) : OptionalInt.empty();
    }

    @Override
    protected void describeTo(StringBuilder stringBuilder) {
        super.describeTo(stringBuilder);
        stringBuilder.append(", responseType='").append(this.responseType()).append("'").append(", priority='").append(this.priority().orElse(0)).append("'");
    }

    @Override
    protected String describeType() {
        return "GenericQueryMessage";
    }
}

