/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.FluxUtils;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.conversion.MessageConverter;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.queryhandling.GenericQueryMessage;
import org.axonframework.queryhandling.GenericSubscriptionQueryMessage;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryGateway;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryPriorityCalculator;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.serialization.Converter;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class DefaultQueryGateway
implements QueryGateway {
    private final QueryBus queryBus;
    private final MessageTypeResolver messageTypeResolver;
    private final QueryPriorityCalculator priorityCalculator;
    private final MessageConverter converter;

    public DefaultQueryGateway(@Nonnull QueryBus queryBus, @Nonnull MessageTypeResolver messageTypeResolver, @Nonnull QueryPriorityCalculator priorityCalculator, @Nonnull MessageConverter converter) {
        this.queryBus = Objects.requireNonNull(queryBus, "The QueryBus must not be null.");
        this.messageTypeResolver = Objects.requireNonNull(messageTypeResolver, "The MessageTypeResolver must not be null.");
        this.priorityCalculator = Objects.requireNonNull(priorityCalculator, "The QueryPriorityCalculator must not be null.");
        this.converter = Objects.requireNonNull(converter, "The MessageConverter must not be null.");
    }

    @Override
    @Nonnull
    public <R> CompletableFuture<R> query(@Nonnull Object query, @Nonnull Class<R> responseType, @Nullable ProcessingContext context) {
        QueryMessage queryMessage = this.asQueryMessage(query, responseType);
        MessageStream<QueryResponseMessage> resultStream = this.queryBus.query(queryMessage, context);
        CompletionStage resultFuture = ((CompletableFuture)resultStream.first().asCompletableFuture().thenApply(MessageStream.Entry::message)).thenApply(queryResponseMessage -> {
            if (queryResponseMessage == null) {
                return null;
            }
            return queryResponseMessage.payloadAs(responseType, (Converter)this.converter);
        });
        ((CompletableFuture)resultFuture).whenComplete((r, e) -> {
            if (!resultStream.isCompleted()) {
                resultStream.close();
            }
        });
        return resultFuture;
    }

    @Override
    @Nonnull
    public <R> CompletableFuture<List<R>> queryMany(@Nonnull Object query, @Nonnull Class<R> responseType, @Nullable ProcessingContext context) {
        QueryMessage queryMessage = this.asQueryMessage(query, responseType);
        MessageStream<QueryResponseMessage> resultStream = this.queryBus.query(queryMessage, context);
        CompletableFuture<List<R>> resultFuture = resultStream.reduce(new ArrayList(), (list, entry) -> {
            list.add(((QueryResponseMessage)entry.message()).payloadAs(responseType, (Converter)this.converter));
            return list;
        });
        resultFuture.whenComplete((r, e) -> {
            if (!resultStream.isCompleted()) {
                resultStream.close();
            }
        });
        return resultFuture;
    }

    @Override
    @Nonnull
    public <R> Publisher<R> streamingQuery(@Nonnull Object query, @Nonnull Class<R> responseType, @Nullable ProcessingContext context) {
        return Mono.fromSupplier(() -> this.asQueryMessage(query, responseType)).flatMapMany(queryMessage -> FluxUtils.of(this.queryBus.query((QueryMessage)queryMessage, context))).map(MessageStream.Entry::message).mapNotNull(m -> m.payloadAs(responseType, (Converter)this.converter));
    }

    @Override
    @Nonnull
    public <R> Publisher<R> subscriptionQuery(@Nonnull Object query, @Nonnull Class<R> responseType, @Nullable ProcessingContext context, int updateBufferSize) {
        return this.subscriptionQuery(query, responseType, m -> m.payloadAs(responseType, (Converter)this.converter), context, updateBufferSize);
    }

    @Override
    @Nonnull
    public <T> Publisher<T> subscriptionQuery(@Nonnull Object query, @Nonnull Class<T> responseType, @Nonnull Function<QueryResponseMessage, T> mapper, @Nullable ProcessingContext context, int updateBufferSize) {
        SubscriptionQueryMessage queryMessage = this.asSubscriptionQueryMessage(query, this.resolveTypeFor(responseType));
        MessageStream<QueryResponseMessage> response = this.queryBus.subscriptionQuery(queryMessage, context, updateBufferSize);
        return FluxUtils.of(response).mapNotNull(m -> mapper.apply((QueryResponseMessage)m.message())).doOnCancel(response::close).doOnError(e -> response.close());
    }

    private QueryMessage asQueryMessage(Object query, Class<?> responseType) {
        GenericQueryMessage genericQueryMessage;
        if (query instanceof QueryMessage) {
            QueryMessage queryMessage = (QueryMessage)query;
            return queryMessage;
        }
        if (query instanceof Message) {
            Message message = (Message)query;
            genericQueryMessage = new GenericQueryMessage(message, this.resolveTypeFor(responseType));
        } else {
            genericQueryMessage = new GenericQueryMessage(this.resolveTypeFor(query), query, this.resolveTypeFor(responseType));
        }
        return genericQueryMessage;
    }

    private SubscriptionQueryMessage asSubscriptionQueryMessage(Object query, MessageType messageType) {
        if (query instanceof SubscriptionQueryMessage) {
            SubscriptionQueryMessage queryMessage = (SubscriptionQueryMessage)query;
            return queryMessage;
        }
        return query instanceof Message ? new GenericSubscriptionQueryMessage((Message)query, messageType) : new GenericSubscriptionQueryMessage(this.resolveTypeFor(query), query, messageType);
    }

    private MessageType resolveTypeFor(Object payload) {
        return this.messageTypeResolver.resolveOrThrow(payload);
    }

    private MessageType resolveTypeFor(Class<?> clazz) {
        return this.messageTypeResolver.resolveOrThrow(clazz);
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("queryBus", this.queryBus);
        descriptor.describeProperty("messageTypeResolver", this.messageTypeResolver);
        descriptor.describeProperty("priorityCalculator", this.priorityCalculator);
    }
}

