/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.monitoring.interceptors;

import jakarta.annotation.Nonnull;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptorChain;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.queryhandling.QueryMessage;

public class MonitoringQueryHandlerInterceptor
implements MessageHandlerInterceptor<QueryMessage> {
    private final MessageMonitor<? super QueryMessage> messageMonitor;

    public MonitoringQueryHandlerInterceptor(@Nonnull MessageMonitor<? super QueryMessage> messageMonitor) {
        this.messageMonitor = messageMonitor;
    }

    @Override
    @Nonnull
    public MessageStream<?> interceptOnHandle(@Nonnull QueryMessage message, @Nonnull ProcessingContext context, @Nonnull MessageHandlerInterceptorChain<QueryMessage> interceptorChain) {
        if (context.isStarted()) {
            MessageMonitor.MonitorCallback monitorCallback = this.messageMonitor.onMessageIngested(message);
            context.onError((ctx, phase, error) -> monitorCallback.reportFailure(error));
            context.runOnAfterCommit(ctx -> monitorCallback.reportSuccess());
        }
        return interceptorChain.proceed(message, context);
    }
}

