/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.monitoring.interceptors;

import jakarta.annotation.Nonnull;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptorChain;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.monitoring.MessageMonitor;

public class MonitoringCommandHandlerInterceptor
implements MessageHandlerInterceptor<CommandMessage> {
    private final MessageMonitor<? super CommandMessage> messageMonitor;

    public MonitoringCommandHandlerInterceptor(@Nonnull MessageMonitor<? super CommandMessage> messageMonitor) {
        this.messageMonitor = messageMonitor;
    }

    @Override
    @Nonnull
    public MessageStream<?> interceptOnHandle(@Nonnull CommandMessage message, @Nonnull ProcessingContext context, @Nonnull MessageHandlerInterceptorChain<CommandMessage> interceptorChain) {
        if (context.isStarted()) {
            MessageMonitor.MonitorCallback monitorCallback = this.messageMonitor.onMessageIngested(message);
            context.onError((ctx, phase, error) -> monitorCallback.reportFailure(error));
            context.runOnAfterCommit(ctx -> monitorCallback.reportSuccess());
        }
        return interceptorChain.proceed(message, context);
    }
}

