/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.unitofwork;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.annotations.Internal;
import org.axonframework.messaging.ApplicationContext;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.messaging.unitofwork.ProcessingLifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitOfWork
implements ProcessingLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(UnitOfWork.class);
    private final String identifier;
    private final UnitOfWorkProcessingContext context;

    @Internal
    UnitOfWork(@Nonnull String identifier, @Nonnull Executor workScheduler, @Nonnull ApplicationContext applicationContext) {
        Objects.requireNonNull(identifier, "identifier may not be null.");
        Objects.requireNonNull(workScheduler, "workScheduler may not be null.");
        Objects.requireNonNull(applicationContext, "applicationContext may not be null.");
        this.identifier = identifier;
        this.context = new UnitOfWorkProcessingContext(identifier, workScheduler, applicationContext);
    }

    @Override
    public boolean isStarted() {
        return this.context.isStarted();
    }

    @Override
    public boolean isError() {
        return this.context.isError();
    }

    @Override
    public boolean isCommitted() {
        return this.context.isCommitted();
    }

    @Override
    public boolean isCompleted() {
        return this.context.isCompleted();
    }

    @Override
    public UnitOfWork on(ProcessingLifecycle.Phase phase, Function<ProcessingContext, CompletableFuture<?>> action) {
        this.context.on(phase, action);
        return this;
    }

    @Override
    public ProcessingLifecycle onError(ProcessingLifecycle.ErrorHandler action) {
        return this.context.onError(action);
    }

    @Override
    public ProcessingLifecycle whenComplete(Consumer<ProcessingContext> action) {
        return this.context.whenComplete(action);
    }

    public CompletableFuture<Void> execute() {
        return this.context.commit();
    }

    public <R> CompletableFuture<R> executeWithResult(Function<ProcessingContext, CompletableFuture<R>> action) {
        CompletableFuture result = new CompletableFuture();
        this.onInvocation(processingContext -> this.safe(() -> (CompletableFuture)action.apply((ProcessingContext)processingContext)).whenComplete(FutureUtils.alsoComplete(result)));
        return this.execute().thenCombine((CompletionStage)result, (executeResult, invocationResult) -> invocationResult);
    }

    private <R> CompletableFuture<R> safe(Callable<CompletableFuture<R>> action) {
        try {
            CompletableFuture<R> result = action.call();
            if (result == null) {
                return CompletableFuture.failedFuture(new NullPointerException("The action returned a null CompletableFuture."));
            }
            return result;
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public String toString() {
        return "UnitOfWork{identifier='" + this.identifier + "'phase='" + String.valueOf(this.context.currentPhase.get()) + "'}";
    }

    private static class UnitOfWorkProcessingContext
    implements ProcessingContext {
        private final AtomicReference<Status> status = new AtomicReference<Status>(Status.NOT_STARTED);
        private final AtomicReference<ProcessingLifecycle.Phase> currentPhase = new AtomicReference<Object>(null);
        private final ConcurrentNavigableMap<ProcessingLifecycle.Phase, Queue<Function<ProcessingContext, CompletableFuture<?>>>> phaseActions = new ConcurrentSkipListMap(Comparator.comparingInt(ProcessingLifecycle.Phase::order));
        private final Queue<Consumer<ProcessingContext>> completeHandlers = new ConcurrentLinkedQueue<Consumer<ProcessingContext>>();
        private final Queue<ProcessingLifecycle.ErrorHandler> errorHandlers = new ConcurrentLinkedQueue<ProcessingLifecycle.ErrorHandler>();
        private final AtomicReference<CauseAndPhase> errorCause = new AtomicReference();
        private final String identifier;
        private final Executor workScheduler;
        private final ApplicationContext applicationContext;
        private final ConcurrentMap<Context.ResourceKey<?>, Object> resources;

        private UnitOfWorkProcessingContext(String identifier, Executor workScheduler, ApplicationContext applicationContext) {
            this.identifier = identifier;
            this.workScheduler = workScheduler;
            this.resources = new ConcurrentHashMap();
            this.applicationContext = applicationContext;
        }

        @Override
        public boolean isStarted() {
            return this.status.get() != Status.NOT_STARTED;
        }

        @Override
        public boolean isError() {
            return this.status.get() == Status.COMPLETED_ERROR;
        }

        @Override
        public boolean isCommitted() {
            return this.status.get() == Status.COMPLETED;
        }

        @Override
        public boolean isCompleted() {
            Status currentStatus = this.status.get();
            return currentStatus == Status.COMPLETED || currentStatus == Status.COMPLETED_ERROR;
        }

        @Override
        public ProcessingLifecycle on(ProcessingLifecycle.Phase phase, Function<ProcessingContext, CompletableFuture<?>> action) {
            ProcessingLifecycle.Phase current = this.currentPhase.get();
            if (current != null && phase.order() <= current.order()) {
                throw new IllegalStateException("Failed to register handler in phase " + String.valueOf(phase) + " (" + phase.order() + "). ProcessingContext is already in phase " + String.valueOf(current) + " (" + current.order() + ").");
            }
            this.phaseActions.computeIfAbsent(phase, p -> new ConcurrentLinkedQueue()).add(this.safe(phase, action));
            return this;
        }

        private Function<ProcessingContext, CompletableFuture<?>> safe(ProcessingLifecycle.Phase phase, Function<ProcessingContext, CompletableFuture<?>> action) {
            return processingContext -> {
                CompletableFuture result;
                try {
                    result = (CompletableFuture)action.apply((ProcessingContext)processingContext);
                }
                catch (Exception e2) {
                    result = CompletableFuture.failedFuture(e2);
                }
                return result.exceptionallyCompose(e -> {
                    if (!this.errorCause.compareAndSet(null, new CauseAndPhase(phase, (Throwable)e))) {
                        this.errorCause.get().cause().addSuppressed((Throwable)e);
                    }
                    return CompletableFuture.failedFuture(e);
                });
            };
        }

        @Override
        public ProcessingLifecycle onError(ProcessingLifecycle.ErrorHandler action) {
            ProcessingLifecycle.ErrorHandler silentAction = this.failSilently(action);
            this.errorHandlers.add(silentAction);
            Status currentStatus = this.status.get();
            if (currentStatus == Status.COMPLETED_ERROR && this.errorHandlers.remove(silentAction)) {
                CauseAndPhase causeAndPhase = this.errorCause.get();
                silentAction.handle(this, causeAndPhase.phase(), causeAndPhase.cause());
            }
            return this;
        }

        private ProcessingLifecycle.ErrorHandler failSilently(ProcessingLifecycle.ErrorHandler action) {
            return (context, phase, exception) -> {
                try {
                    action.handle(context, phase, exception);
                }
                catch (Exception e) {
                    logger.warn("An onError handler threw an exception.", (Throwable)e);
                }
            };
        }

        @Override
        public ProcessingLifecycle whenComplete(Consumer<ProcessingContext> action) {
            Consumer<ProcessingContext> silentAction = this.completeSilently(action);
            this.completeHandlers.add(silentAction);
            Status currentStatus = this.status.get();
            if (currentStatus == Status.COMPLETED && this.completeHandlers.remove(silentAction)) {
                silentAction.accept(this);
            }
            return this;
        }

        private Consumer<ProcessingContext> completeSilently(Consumer<ProcessingContext> action) {
            return processingContext -> {
                try {
                    action.accept((ProcessingContext)processingContext);
                }
                catch (Exception e) {
                    logger.warn("A Completion handler threw an exception.", (Throwable)e);
                }
            };
        }

        private CompletableFuture<Void> commit() {
            if (!this.status.compareAndSet(Status.NOT_STARTED, Status.STARTED)) {
                throw new IllegalStateException("Cannot switch [" + String.valueOf((Object)this.status.get()) + "] to STARTED. This ProcessingContext cannot be committed (again).");
            }
            return ((CompletableFuture)this.executeAllPhaseHandlers().thenRun(this::runCompletionHandlers)).exceptionallyCompose(this::runErrorHandlers);
        }

        private CompletableFuture<Void> executeAllPhaseHandlers() {
            if (this.phaseActions.isEmpty()) {
                return FutureUtils.emptyCompletedFuture();
            }
            CompletableFuture<Void> nextPhaseResult = this.runNextPhase().toCompletableFuture();
            while (!this.phaseActions.isEmpty() && nextPhaseResult.isDone()) {
                if (nextPhaseResult.isCompletedExceptionally()) {
                    return nextPhaseResult;
                }
                nextPhaseResult = this.runNextPhase().toCompletableFuture();
            }
            return nextPhaseResult.thenCompose(result -> this.executeAllPhaseHandlers());
        }

        private void runCompletionHandlers() {
            this.status.set(Status.COMPLETED);
            while (!this.completeHandlers.isEmpty()) {
                Consumer<ProcessingContext> nextCompletionHandler = this.completeHandlers.poll();
                if (nextCompletionHandler == null) continue;
                this.workScheduler.execute(() -> nextCompletionHandler.accept(this));
            }
        }

        private CompletionStage<Void> runErrorHandlers(Throwable e) {
            this.status.set(Status.COMPLETED_ERROR);
            CauseAndPhase recordedCause = this.errorCause.get();
            while (!this.errorHandlers.isEmpty()) {
                ProcessingLifecycle.ErrorHandler nextErrorHandler = this.errorHandlers.poll();
                if (nextErrorHandler == null) continue;
                this.workScheduler.execute(() -> nextErrorHandler.handle(this, recordedCause.phase(), recordedCause.cause()));
            }
            return CompletableFuture.failedFuture(e);
        }

        private CompletableFuture<Void> runNextPhase() {
            if (this.phaseActions.isEmpty()) {
                return FutureUtils.emptyCompletedFuture();
            }
            ProcessingLifecycle.Phase current = (ProcessingLifecycle.Phase)this.phaseActions.firstKey();
            this.currentPhase.set(current);
            Queue actionQueue = (Queue)this.phaseActions.remove(current);
            if (actionQueue == null || actionQueue.isEmpty()) {
                logger.debug("Skipping phase {} (with order [{}]), since no actions are registered.", (Object)current, (Object)current.order());
                return FutureUtils.emptyCompletedFuture();
            }
            logger.debug("Calling {}# actions in phase {} (with order {}).", new Object[]{actionQueue.size(), current, current.order()});
            return actionQueue.stream().map(handler -> ((CompletableFuture)FutureUtils.emptyCompletedFuture().thenComposeAsync(result -> (CompletionStage)handler.apply(this), this.workScheduler)).thenAccept(FutureUtils::ignoreResult)).reduce((xva$0, xva$1) -> CompletableFuture.allOf(xva$0, xva$1)).orElseGet(FutureUtils::emptyCompletedFuture);
        }

        @Override
        public boolean containsResource(@Nonnull Context.ResourceKey<?> key) {
            return this.resources.containsKey(key);
        }

        @Override
        public <T> T getResource(@Nonnull Context.ResourceKey<T> key) {
            return (T)this.resources.get(key);
        }

        @Override
        public Map<Context.ResourceKey<?>, Object> resources() {
            return Map.copyOf(this.resources);
        }

        @Override
        public <T> T putResource(@Nonnull Context.ResourceKey<T> key, @Nonnull T resource) {
            return this.resources.put(key, resource);
        }

        @Override
        public <T> T updateResource(@Nonnull Context.ResourceKey<T> key, @Nonnull UnaryOperator<T> resourceUpdater) {
            return (T)this.resources.compute(key, (k, v) -> resourceUpdater.apply(v));
        }

        @Override
        public <T> T putResourceIfAbsent(@Nonnull Context.ResourceKey<T> key, @Nonnull T resource) {
            return (T)this.resources.putIfAbsent(key, resource);
        }

        @Override
        public <T> T computeResourceIfAbsent(@Nonnull Context.ResourceKey<T> key, @Nonnull Supplier<T> resourceSupplier) {
            return (T)this.resources.computeIfAbsent(key, t -> resourceSupplier.get());
        }

        @Override
        public <T> T removeResource(@Nonnull Context.ResourceKey<T> key) {
            return (T)this.resources.remove(key);
        }

        @Override
        public <T> boolean removeResource(@Nonnull Context.ResourceKey<T> key, @Nonnull T expectedResource) {
            return this.resources.remove(key, expectedResource);
        }

        @Override
        @Nonnull
        public <C> C component(@Nonnull Class<C> type, @Nullable String name) {
            return this.applicationContext.component(type, name);
        }

        @Override
        @Nonnull
        public <C> C component(@Nonnull Class<C> type) {
            return this.applicationContext.component(type);
        }

        public String toString() {
            return "UnitOfWorkProcessingContext{identifier='" + this.identifier + "', currentPhase=" + String.valueOf(this.currentPhase.get()) + "}";
        }

        private static enum Status {
            NOT_STARTED,
            STARTED,
            COMPLETED_ERROR,
            COMPLETED;

        }

        private record CauseAndPhase(ProcessingLifecycle.Phase phase, Throwable cause) {
        }
    }
}

