/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotations;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.axonframework.common.Priority;
import org.axonframework.messaging.LegacyResources;
import org.axonframework.messaging.annotations.AbstractAnnotatedParameterResolverFactory;
import org.axonframework.messaging.annotations.ParameterResolver;
import org.axonframework.messaging.annotations.SourceId;
import org.axonframework.messaging.unitofwork.ProcessingContext;

@Priority(value=0x3FFFFFFF)
public final class SourceIdParameterResolverFactory
extends AbstractAnnotatedParameterResolverFactory<SourceId, String> {
    private final ParameterResolver<String> resolver = new SourceIdParameterResolver();

    public SourceIdParameterResolverFactory() {
        super(SourceId.class, String.class);
    }

    @Override
    protected ParameterResolver<String> getResolver() {
        return this.resolver;
    }

    static class SourceIdParameterResolver
    implements ParameterResolver<String> {
        SourceIdParameterResolver() {
        }

        @Override
        @Nullable
        public String resolveParameterValue(@Nonnull ProcessingContext context) {
            String sourceId = context.getResource(LegacyResources.AGGREGATE_IDENTIFIER_KEY);
            if (sourceId != null) {
                return sourceId;
            }
            throw new IllegalArgumentException();
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            return context.containsResource(LegacyResources.AGGREGATE_IDENTIFIER_KEY);
        }
    }
}

