/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;

public class DelayedMessageStream<M extends Message>
implements MessageStream<M> {
    private final CompletableFuture<? extends MessageStream<M>> delegate;

    private DelayedMessageStream(@Nonnull CompletableFuture<? extends MessageStream<M>> delegate) {
        this.delegate = delegate;
    }

    public static <M extends Message> MessageStream<M> create(@Nonnull CompletableFuture<? extends MessageStream<M>> delegate) {
        CompletionStage safeDelegate = ((CompletableFuture)delegate.exceptionallyCompose(CompletableFuture::failedFuture)).thenApply(ms -> Objects.requireNonNullElse(ms, MessageStream.empty().cast()));
        if (((CompletableFuture)safeDelegate).isDone()) {
            try {
                return delegate.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return new DelayedMessageStream<M>(safeDelegate);
            }
            catch (ExecutionException e) {
                return MessageStream.failed(e.getCause());
            }
        }
        return new DelayedMessageStream<M>(safeDelegate);
    }

    public static <M extends Message> MessageStream.Single<M> createSingle(@Nonnull CompletableFuture<MessageStream.Single<M>> delegate) {
        CompletionStage safeDelegate = ((CompletableFuture)delegate.exceptionallyCompose(CompletableFuture::failedFuture)).thenApply(ms -> Objects.requireNonNullElse(ms, MessageStream.empty().cast()));
        if (((CompletableFuture)safeDelegate).isDone()) {
            try {
                return delegate.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return new Single(safeDelegate);
            }
            catch (ExecutionException e) {
                return MessageStream.failed(e.getCause());
            }
        }
        return new Single(safeDelegate);
    }

    @Override
    public Optional<MessageStream.Entry<M>> next() {
        if (this.delegate.isDone() && !this.delegate.isCompletedExceptionally()) {
            return ((MessageStream)this.delegate.getNow(null)).next();
        }
        return Optional.empty();
    }

    @Override
    public void onAvailable(@Nonnull Runnable callback) {
        this.delegate.whenComplete((T r, U e) -> {
            if (r != null) {
                r.onAvailable(callback);
            } else {
                callback.run();
            }
        });
    }

    @Override
    public Optional<Throwable> error() {
        if (this.delegate.isDone()) {
            if (this.delegate.isCompletedExceptionally() && !this.delegate.isCancelled()) {
                return Optional.of(this.delegate.exceptionNow());
            }
            try {
                return ((MessageStream)this.delegate.getNow(null)).error();
            }
            catch (CancellationException | CompletionException e) {
                return Optional.of(e);
            }
        }
        return Optional.empty();
    }

    @Override
    public boolean isCompleted() {
        return this.delegate.isDone() && (this.delegate.isCompletedExceptionally() || ((MessageStream)this.delegate.getNow(null)).isCompleted());
    }

    @Override
    public boolean hasNextAvailable() {
        return this.delegate.isDone() && !this.delegate.isCompletedExceptionally() && ((MessageStream)this.delegate.getNow(null)).hasNextAvailable();
    }

    @Override
    public void close() {
        if (this.delegate.isDone()) {
            if (!this.delegate.isCompletedExceptionally()) {
                ((MessageStream)this.delegate.getNow(null)).close();
            }
        } else {
            this.delegate.cancel(false);
        }
    }

    @Override
    public <R> CompletableFuture<R> reduce(@Nonnull R identity, @Nonnull BiFunction<R, MessageStream.Entry<M>, R> accumulator) {
        return this.delegate.thenCompose(delegateStream -> delegateStream.reduce(identity, accumulator));
    }

    @Override
    public Optional<MessageStream.Entry<M>> peek() {
        if (this.delegate.isDone() && !this.delegate.isCompletedExceptionally()) {
            return ((MessageStream)this.delegate.getNow(null)).peek();
        }
        return Optional.empty();
    }

    static class Single<M extends Message>
    extends DelayedMessageStream<M>
    implements MessageStream.Single<M> {
        Single(@Nonnull CompletableFuture<MessageStream.Single<M>> delegate) {
            super(delegate);
        }
    }

    static class Empty<M extends Message>
    extends DelayedMessageStream<M>
    implements MessageStream.Empty<M> {
        Empty(@Nonnull CompletableFuture<MessageStream.Empty<M>> delegate) {
            super(delegate);
        }
    }
}

