/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.configuration;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.axonframework.common.Assert;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.configuration.Component;
import org.axonframework.configuration.ComponentDefinition;
import org.axonframework.configuration.ComponentFactory;
import org.axonframework.configuration.ComponentOverrideException;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.Components;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.configuration.DecoratorDefinition;
import org.axonframework.configuration.DuplicateModuleRegistrationException;
import org.axonframework.configuration.HierarchicalConfiguration;
import org.axonframework.configuration.LazyInitializedComponentDefinition;
import org.axonframework.configuration.LifecycleRegistry;
import org.axonframework.configuration.Module;
import org.axonframework.configuration.OverridePolicy;
import org.axonframework.configuration.SearchScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultComponentRegistry
implements ComponentRegistry {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Components components = new Components();
    private final List<DecoratorDefinition.CompletedDecoratorDefinition<?, ?>> decoratorDefinitions = new ArrayList();
    private final Map<String, ConfigurationEnhancer> enhancers = new LinkedHashMap<String, ConfigurationEnhancer>();
    private final Map<String, Module> modules = new ConcurrentHashMap<String, Module>();
    private final List<ComponentFactory<?>> factories = new ArrayList();
    private final AtomicReference<Configuration> initialized = new AtomicReference();
    private final Map<String, Configuration> moduleConfigurations = new ConcurrentHashMap<String, Configuration>();
    private OverridePolicy overridePolicy = OverridePolicy.WARN;
    private boolean enhancerScanning = true;
    private final List<Class<? extends ConfigurationEnhancer>> disabledEnhancers = new ArrayList<Class<? extends ConfigurationEnhancer>>();
    private final List<Class<? extends ConfigurationEnhancer>> invokedEnhancers = new ArrayList<Class<? extends ConfigurationEnhancer>>();
    private Optional<Configuration> parentConfig = Optional.empty();

    @Override
    public <C> ComponentRegistry registerComponent(@Nonnull ComponentDefinition<? extends C> definition) {
        Objects.requireNonNull(definition, "The ComponentDefinition must not be null.");
        if (!(definition instanceof ComponentDefinition.ComponentCreator)) {
            throw new IllegalArgumentException("Unsupported component definition type: " + String.valueOf(definition));
        }
        ComponentDefinition.ComponentCreator creator = (ComponentDefinition.ComponentCreator)definition;
        Component component = creator.createComponent();
        Component.Identifier id = component.identifier();
        logger.debug("Registering component [{}] of type [{}].", (Object)id.name(), id.type());
        if (this.overridePolicy == OverridePolicy.REJECT && this.hasComponent(id.typeAsClass(), id.name())) {
            throw new ComponentOverrideException(id.typeAsClass(), id.name());
        }
        Component previous = this.components.put(component);
        if (previous != null && this.overridePolicy == OverridePolicy.WARN) {
            logger.warn("Replaced a previous Component registered for type [{}] and name [{}].", (Object)id.name(), id.type());
        }
        return this;
    }

    @Override
    public <C> ComponentRegistry registerDecorator(@Nonnull DecoratorDefinition<C, ? extends C> definition) {
        Objects.requireNonNull(definition, "The decorator definition must not be null.");
        if (!(definition instanceof DecoratorDefinition.CompletedDecoratorDefinition)) {
            throw new IllegalArgumentException("Unsupported decorator definition type: " + String.valueOf(definition));
        }
        DecoratorDefinition.CompletedDecoratorDefinition decoratorRegistration = (DecoratorDefinition.CompletedDecoratorDefinition)definition;
        logger.debug("Registering decorator definition: [{}]", definition);
        this.decoratorDefinitions.add(decoratorRegistration);
        return this;
    }

    @Override
    public boolean hasComponent(@Nonnull Class<?> type, @Nullable String name, @Nonnull SearchScope searchScope) {
        return switch (searchScope) {
            default -> throw new MatchException(null, null);
            case SearchScope.ALL -> {
                if (this.components.contains(new Component.Identifier(type, name)) || this.parentHasComponent(type, name).booleanValue()) {
                    yield true;
                }
                yield false;
            }
            case SearchScope.CURRENT -> this.components.contains(new Component.Identifier(type, name));
            case SearchScope.ANCESTORS -> this.parentHasComponent(type, name);
        };
    }

    private Boolean parentHasComponent(Class<?> type, String name) {
        return this.parentConfig.map(parent -> parent.hasComponent(type, name)).orElse(false);
    }

    @Override
    public ComponentRegistry registerEnhancer(@Nonnull ConfigurationEnhancer enhancer) {
        logger.debug("Registering enhancer [{}].", (Object)enhancer.getClass().getSimpleName());
        ConfigurationEnhancer previous = this.enhancers.put(enhancer.getClass().getName(), enhancer);
        if (previous != null) {
            logger.warn("Duplicate Configuration Enhancer registration dedicated. Replaced enhancer of type [{}].", (Object)enhancer.getClass().getSimpleName());
        }
        return this;
    }

    @Override
    public ComponentRegistry registerModule(@Nonnull Module module) {
        if (logger.isDebugEnabled()) {
            logger.debug("Registering module [{}].", (Object)module.name());
        }
        if (this.modules.containsKey(module.name())) {
            throw new DuplicateModuleRegistrationException(module);
        }
        this.modules.put(module.name(), module);
        return this;
    }

    @Override
    public <C> ComponentRegistry registerFactory(@Nonnull ComponentFactory<C> factory) {
        if (logger.isDebugEnabled()) {
            logger.debug("Registering component factory [{}].", (Object)factory.getClass().getSimpleName());
        }
        this.factories.add(factory);
        return this;
    }

    public Configuration build(@Nonnull LifecycleRegistry lifecycleRegistry) {
        return this.doBuild(null, lifecycleRegistry);
    }

    public Configuration buildNested(@Nonnull Configuration parent, @Nonnull LifecycleRegistry lifecycleRegistry) {
        return this.doBuild(Objects.requireNonNull(parent), Objects.requireNonNull(lifecycleRegistry));
    }

    private Configuration doBuild(@Nullable Configuration optionalParent, @Nonnull LifecycleRegistry lifecycleRegistry) {
        Configuration configuration = this.initialized.get();
        if (configuration != null) {
            return configuration;
        }
        this.parentConfig = Optional.ofNullable(optionalParent);
        if (this.enhancerScanning) {
            this.scanForConfigurationEnhancers();
        }
        this.invokeEnhancers();
        this.decorateComponents();
        LocalConfiguration config = new LocalConfiguration(optionalParent);
        this.buildModules(config, lifecycleRegistry);
        this.initializeComponents(config, lifecycleRegistry);
        this.registerFactoryShutdownHandlers(lifecycleRegistry);
        this.initialized.set(config);
        return config;
    }

    private void decorateComponents() {
        this.decoratorDefinitions.sort(Comparator.comparingInt(DecoratorDefinition.CompletedDecoratorDefinition::order));
        for (DecoratorDefinition.CompletedDecoratorDefinition<?, ?> decorator : this.decoratorDefinitions) {
            for (Component.Identifier<?> id : this.components.identifiers()) {
                if (!decorator.matches(id)) continue;
                this.components.replace(id, decorator::decorate);
            }
        }
    }

    private void invokeEnhancers() {
        Optional<Map.Entry> nextEnhancer;
        HashSet<String> processedEnhancerKeys = new HashSet<String>();
        while (processedEnhancerKeys.size() < this.enhancers.size() && !(nextEnhancer = this.enhancers.entrySet().stream().filter(entry -> !processedEnhancerKeys.contains(entry.getKey())).min(Comparator.comparingInt(entry -> ((ConfigurationEnhancer)entry.getValue()).order()))).isEmpty()) {
            Map.Entry entry2 = nextEnhancer.get();
            String key = (String)entry2.getKey();
            ConfigurationEnhancer enhancer = (ConfigurationEnhancer)entry2.getValue();
            if (!this.disabledEnhancers.contains(enhancer.getClass())) {
                enhancer.enhance(this);
                this.invokedEnhancers.add(enhancer.getClass());
            }
            processedEnhancerKeys.add(key);
        }
    }

    private void buildModules(Configuration config, LifecycleRegistry lifecycleRegistry) {
        for (Module module : this.modules.values()) {
            Configuration builtModule = HierarchicalConfiguration.build(lifecycleRegistry, childLifecycleRegistry -> module.build(config, (LifecycleRegistry)childLifecycleRegistry));
            this.moduleConfigurations.put(module.name(), builtModule);
        }
    }

    private void initializeComponents(Configuration config, LifecycleRegistry lifecycleRegistry) {
        this.components.postProcessComponents(c -> c.initLifecycle(config, lifecycleRegistry));
    }

    private void registerFactoryShutdownHandlers(LifecycleRegistry lifecycleRegistry) {
        this.factories.forEach(factory -> factory.registerShutdownHandlers(lifecycleRegistry));
    }

    @Override
    public DefaultComponentRegistry setOverridePolicy(@Nonnull OverridePolicy overridePolicy) {
        this.overridePolicy = Objects.requireNonNull(overridePolicy, "The override policy must not be null.");
        return this;
    }

    @Override
    public ComponentRegistry disableEnhancer(@Nonnull String fullyQualifiedClassName) {
        Objects.requireNonNull(fullyQualifiedClassName, "The fully qualified class name must not be null.");
        try {
            Class<?> enhancerClass = Class.forName(fullyQualifiedClassName);
            if (!ConfigurationEnhancer.class.isAssignableFrom(enhancerClass)) {
                throw new IllegalArgumentException(String.format("Class %s is not a ConfigurationEnhancer", fullyQualifiedClassName));
            }
            return this.disableEnhancer(enhancerClass);
        }
        catch (ClassNotFoundException e) {
            logger.warn("Disabling Configuration Enhancer [{}] won't take effect as the enhancer class could not be found.", (Object)fullyQualifiedClassName);
            return this;
        }
    }

    @Override
    public DefaultComponentRegistry disableEnhancer(Class<? extends ConfigurationEnhancer> enhancerClass) {
        if (this.invokedEnhancers.contains(enhancerClass)) {
            logger.warn("Disabling Configuration Enhancer [{}] won't take effect as it has already been invoked. We recommend to invoke disabling of this enhancer before it takes effect.", (Object)enhancerClass.getSimpleName());
            return this;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Configuration Enhancer [{}] has been disabled. Ensure components set by this enhancer are not mandatory in this application.", enhancerClass);
        }
        this.disabledEnhancers.add(enhancerClass);
        return this;
    }

    @Override
    public DefaultComponentRegistry disableEnhancerScanning() {
        this.enhancerScanning = false;
        return this;
    }

    private void scanForConfigurationEnhancers() {
        ServiceLoader<ConfigurationEnhancer> enhancerLoader = ServiceLoader.load(ConfigurationEnhancer.class, this.getClass().getClassLoader());
        enhancerLoader.stream().map(ServiceLoader.Provider::get).filter(enhancer -> !this.disabledEnhancers.contains(enhancer.getClass())).filter(this::isNotYetRegistered).forEach(this::registerEnhancer);
    }

    private boolean isNotYetRegistered(ConfigurationEnhancer enhancer) {
        return !this.enhancers.containsKey(enhancer.getClass().getName());
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("initialized", this.initialized.get() != null);
        descriptor.describeProperty("components", this.components);
        descriptor.describeProperty("decorators", this.decoratorDefinitions);
        descriptor.describeProperty("configurerEnhancers", this.enhancers);
        descriptor.describeProperty("modules", this.modules.values());
        descriptor.describeProperty("factories", this.factories);
    }

    private class LocalConfiguration
    implements Configuration {
        private final Configuration parent;

        public LocalConfiguration(Configuration parent) {
            this.parent = parent;
        }

        @Override
        public Configuration getParent() {
            return this.parent;
        }

        @Override
        @Nonnull
        public <C> Optional<C> getOptionalComponent(@Nonnull Class<C> type, @Nullable String name) {
            return DefaultComponentRegistry.this.components.get(new Component.Identifier<C>(type, name)).map(c -> c.resolve(this)).or(() -> {
                Optional factoryComponent = this.fromFactory(type, name);
                if (factoryComponent.isPresent()) {
                    DefaultComponentRegistry.this.components.put(factoryComponent.get());
                    return factoryComponent.map(creator -> creator.resolve(this));
                }
                return Optional.empty();
            }).or(() -> Optional.ofNullable(this.fromParent(type, name, () -> null)));
        }

        @Override
        @Nonnull
        public <C> C getComponent(@Nonnull Class<C> type, @Nullable String name, @Nonnull Supplier<C> defaultImpl) {
            Component.Identifier identifier = new Component.Identifier(type, name);
            C component = DefaultComponentRegistry.this.components.computeIfAbsent(identifier, () -> this.fromFactory(type, name).orElseGet(() -> this.lambda$getComponent$6(identifier, type, name, (Supplier)defaultImpl))).resolve(this);
            return type.cast(component);
        }

        private <C> Optional<Component<C>> fromFactory(Class<C> type, String name) {
            if (name == null) {
                return Optional.empty();
            }
            for (ComponentFactory<?> factory : DefaultComponentRegistry.this.factories) {
                Optional<Component<C>> factoryComponent;
                if (!type.isAssignableFrom(factory.forType()) || !(factoryComponent = factory.construct(name, this)).isPresent()) continue;
                return factoryComponent;
            }
            return Optional.empty();
        }

        private <C> C fromParent(Class<C> type, String name, Supplier<C> defaultSupplier) {
            return this.parent != null ? this.parent.getOptionalComponent(type, name).orElseGet(defaultSupplier) : defaultSupplier.get();
        }

        @Override
        public List<Configuration> getModuleConfigurations() {
            return List.copyOf(DefaultComponentRegistry.this.moduleConfigurations.values());
        }

        @Override
        public void describeTo(@Nonnull ComponentDescriptor descriptor) {
            descriptor.describeProperty("components", DefaultComponentRegistry.this.components);
            descriptor.describeProperty("modules", DefaultComponentRegistry.this.moduleConfigurations.values());
        }

        @Override
        public Optional<Configuration> getModuleConfiguration(@Nonnull String name) {
            Assert.nonEmpty(name, "The name must not be null.");
            return Optional.ofNullable(DefaultComponentRegistry.this.moduleConfigurations.get(name));
        }

        @Override
        @Nonnull
        public <C> Map<String, C> getComponents(@Nonnull Class<C> type) {
            LinkedHashMap result = new LinkedHashMap();
            for (Component.Identifier<?> identifier : DefaultComponentRegistry.this.components.identifiers()) {
                if (!type.isAssignableFrom(identifier.typeAsClass())) continue;
                Optional<Component<?>> component = DefaultComponentRegistry.this.components.get(identifier);
                component.ifPresent(c -> result.put(identifier.name(), c.resolve(this)));
            }
            for (Configuration moduleConfig : this.getModuleConfigurations()) {
                Map<String, C> moduleComponents = moduleConfig.getComponents(type);
                result.putAll(moduleComponents);
            }
            return Collections.unmodifiableMap(result);
        }

        private /* synthetic */ Component lambda$getComponent$6(Component.Identifier identifier, Class type, String name, Supplier defaultImpl) {
            return new LazyInitializedComponentDefinition(identifier, arg_0 -> this.lambda$getComponent$5(type, name, (Supplier)defaultImpl, arg_0));
        }

        private /* synthetic */ Object lambda$getComponent$5(Class type, String name, Supplier defaultImpl, Configuration c) {
            return this.fromParent(type, name, defaultImpl);
        }
    }
}

