/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.concurrent.CompletableFuture;
import org.axonframework.commandhandling.gateway.CommandResult;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.messaging.Metadata;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public interface CommandGateway
extends DescribableComponent {
    @Nonnull
    default public <R> CompletableFuture<R> send(@Nonnull Object command, @Nonnull Class<R> resultType, @Nullable ProcessingContext context) {
        return this.send(command, context).resultAs(resultType);
    }

    @Nullable
    default public Object sendAndWait(@Nonnull Object command) {
        return this.sendAndWait(command, Object.class);
    }

    @Nullable
    default public Object sendAndWait(@Nonnull Object command, @Nullable ProcessingContext context) {
        return this.sendAndWait(command, Object.class, context);
    }

    @Nullable
    default public <R> R sendAndWait(@Nonnull Object command, @Nonnull Class<R> resultType) {
        return this.sendAndWait(command, resultType, null);
    }

    @Nullable
    default public <R> R sendAndWait(@Nonnull Object command, @Nonnull Class<R> resultType, @Nullable ProcessingContext context) {
        return this.send(command, context).wait(resultType);
    }

    @Nonnull
    public CommandResult send(@Nonnull Object var1, @Nullable ProcessingContext var2);

    @Nonnull
    public CommandResult send(@Nonnull Object var1, @Nonnull Metadata var2, @Nullable ProcessingContext var3);
}

