/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.unitofwork;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWorkConfiguration;
import org.axonframework.messaging.unitofwork.UnitOfWorkFactory;

public class TransactionalUnitOfWorkFactory
implements UnitOfWorkFactory {
    private static final Context.ResourceKey<Transaction> TRANSACTION_RESOURCE_KEY = Context.ResourceKey.withLabel("transaction");
    private final TransactionManager transactionManager;
    private final UnitOfWorkFactory delegate;

    public TransactionalUnitOfWorkFactory(@Nonnull TransactionManager transactionManager, @Nonnull UnitOfWorkFactory delegate) {
        Objects.requireNonNull(transactionManager, "Transaction Manager cannot be null");
        Objects.requireNonNull(delegate, "Delegate UnitOfWorkFactory cannot be null");
        this.transactionManager = transactionManager;
        this.delegate = delegate;
    }

    @Override
    @Nonnull
    public UnitOfWork create(@Nonnull String identifier, @Nonnull UnaryOperator<UnitOfWorkConfiguration> customization) {
        UnitOfWork unitOfWork = this.delegate.create(identifier, customization);
        unitOfWork.runOnPreInvocation(ctx -> {
            Transaction transaction = this.transactionManager.startTransaction();
            ctx.putResource(TRANSACTION_RESOURCE_KEY, transaction);
        });
        unitOfWork.runOnCommit(ctx -> {
            Transaction transaction = ctx.getResource(TRANSACTION_RESOURCE_KEY);
            transaction.commit();
        });
        unitOfWork.onError((ctx, phase, error) -> {
            Transaction transaction = ctx.getResource(TRANSACTION_RESOURCE_KEY);
            transaction.rollback();
        });
        return unitOfWork;
    }
}

