/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.responsetypes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.messaging.responsetypes.AbstractResponseType;
import org.axonframework.messaging.responsetypes.InstanceResponseType;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MultipleInstancesResponseType<R>
extends AbstractResponseType<List<R>> {
    public static final int ITERABLE_MATCH = 1024;
    private static final Logger logger = LoggerFactory.getLogger(MultipleInstancesResponseType.class);
    private final InstanceResponseType<R> instanceResponseType;

    @JsonCreator
    @ConstructorProperties(value={"expectedResponseType"})
    public MultipleInstancesResponseType(@JsonProperty(value="expectedResponseType") Class<R> expectedCollectionGenericType) {
        super(expectedCollectionGenericType);
        this.instanceResponseType = new InstanceResponseType<R>(expectedCollectionGenericType);
    }

    @Override
    public boolean matches(Type responseType) {
        return this.matchRank(responseType) > 0;
    }

    @Override
    public Integer matchRank(Type responseType) {
        if (this.isMatchingIterable(responseType)) {
            return 1024;
        }
        return this.instanceResponseType.matchRank(responseType);
    }

    private boolean isMatchingIterable(Type responseType) {
        Type unwrapped = ReflectionUtils.unwrapIfType(responseType, Future.class);
        return this.isIterableOfExpectedType(unwrapped) || this.isStreamOfExpectedType(unwrapped) || this.isGenericArrayOfExpectedType(unwrapped) || this.isArrayOfExpectedType(unwrapped) || this.isPublisherOfExpectedType(unwrapped);
    }

    @Override
    public List<R> convert(Object response) {
        if (response == null) {
            return Collections.emptyList();
        }
        Class<?> responseType = response.getClass();
        if (this.isArrayOfExpectedType(responseType)) {
            return Arrays.asList((Object[])response);
        }
        if (this.isIterableOfExpectedType(response)) {
            return this.convertToList((Iterable)response);
        }
        if (this.projectReactorOnClassPath()) {
            if (Flux.class.isAssignableFrom(responseType)) {
                return (List)((Flux)response).collectList().block();
            }
            if (Mono.class.isAssignableFrom(responseType)) {
                return Collections.singletonList(((Mono)response).block());
            }
            if (Publisher.class.isAssignableFrom(responseType)) {
                return (List)Flux.from((Publisher)((Publisher)response)).collectList().block();
            }
        }
        if (this.instanceResponseType.matches(responseType)) {
            return Collections.singletonList(this.instanceResponseType.convert(response));
        }
        throw new IllegalArgumentException("Retrieved response [" + String.valueOf(responseType) + "] is not convertible to a List of the expected response type [" + String.valueOf(this.expectedResponseType) + "]");
    }

    @Override
    public Class responseMessagePayloadType() {
        return List.class;
    }

    private boolean isIterableOfExpectedType(Object response) {
        Class<?> responseType = response.getClass();
        boolean isIterableType = Iterable.class.isAssignableFrom(responseType);
        if (!isIterableType) {
            return false;
        }
        Iterator responseIterator = ((Iterable)response).iterator();
        boolean canMatchContainedType = responseIterator.hasNext();
        if (!canMatchContainedType) {
            logger.debug("The given response is an Iterable without any contents, hence we cannot verify if the contained type is assignable to the expected type.");
            return true;
        }
        return this.isAssignableFrom(responseIterator.next().getClass());
    }

    private List<R> convertToList(Iterable<R> responseIterable) {
        ArrayList response = new ArrayList();
        Iterator<R> responseIterator = responseIterable.iterator();
        responseIterator.forEachRemaining(response::add);
        return response;
    }

    public String toString() {
        return "MultipleInstancesResponseType{" + String.valueOf(this.expectedResponseType) + "}";
    }
}

