/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.interceptors;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptorChain;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class CorrelationDataInterceptor<M extends Message>
implements MessageHandlerInterceptor<M> {
    public static final Context.ResourceKey<Map<String, Object>> CORRELATION_DATA = Context.ResourceKey.withLabel("CorrelationData");
    private final List<CorrelationDataProvider> correlationDataProviders;

    public CorrelationDataInterceptor(CorrelationDataProvider ... correlationDataProviders) {
        this(Arrays.asList(correlationDataProviders));
    }

    public CorrelationDataInterceptor(Collection<CorrelationDataProvider> correlationDataProviders) {
        this.correlationDataProviders = new ArrayList<CorrelationDataProvider>(correlationDataProviders);
    }

    @Override
    @Nonnull
    public MessageStream<?> interceptOnHandle(@Nonnull M message, @Nonnull ProcessingContext context, @Nonnull MessageHandlerInterceptorChain<M> interceptorChain) {
        ConcurrentHashMap correlationData = new ConcurrentHashMap();
        this.correlationDataProviders.forEach(c -> correlationData.putAll(c.correlationDataFor((Message)message)));
        return interceptorChain.proceed(message, (ProcessingContext)context.withResource((Context.ResourceKey)CORRELATION_DATA, correlationData));
    }
}

