/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.axonframework.common.Priority;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandlerInterceptorChain;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.messaging.unitofwork.ResourceOverridingProcessingContext;

@Priority(value=0x7FFFFFFF)
public class InterceptorChainParameterResolverFactory
implements ParameterResolverFactory,
ParameterResolver<MessageHandlerInterceptorChain<?>> {
    private static final ThreadLocal<MessageHandlerInterceptorChain<?>> CURRENT = new ThreadLocal();
    private static final Context.ResourceKey<MessageHandlerInterceptorChain<?>> INTERCEPTOR_CHAIN_KEY = Context.ResourceKey.withLabel("InterceptorChain");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R callWithInterceptorChainSync(MessageHandlerInterceptorChain<?> interceptorChain, Callable<R> action) throws Exception {
        MessageHandlerInterceptorChain<?> previous = CURRENT.get();
        CURRENT.set(interceptorChain);
        try {
            R r = action.call();
            return r;
        }
        finally {
            if (previous == null) {
                CURRENT.remove();
            } else {
                CURRENT.set(previous);
            }
        }
    }

    public static <M extends Message> MessageStream<?> callWithInterceptorChain(ProcessingContext processingContext, MessageHandlerInterceptorChain<M> interceptorChain, Function<ProcessingContext, MessageStream<?>> action) {
        ResourceOverridingProcessingContext<MessageHandlerInterceptorChain<M>> newProcessingContext = new ResourceOverridingProcessingContext<MessageHandlerInterceptorChain<M>>(processingContext, INTERCEPTOR_CHAIN_KEY, interceptorChain);
        return action.apply(newProcessingContext);
    }

    public static MessageHandlerInterceptorChain<?> currentInterceptorChain() {
        return CURRENT.get();
    }

    public static <M extends Message> MessageHandlerInterceptorChain<M> currentInterceptorChain(ProcessingContext processingContext) {
        return processingContext.getResource(INTERCEPTOR_CHAIN_KEY);
    }

    @Override
    @Nullable
    public MessageHandlerInterceptorChain<?> resolveParameterValue(@Nonnull ProcessingContext context) {
        MessageHandlerInterceptorChain<?> interceptorChain;
        MessageHandlerInterceptorChain<?> messageHandlerInterceptorChain = interceptorChain = context == null ? null : context.getResource(INTERCEPTOR_CHAIN_KEY);
        if (interceptorChain == null) {
            interceptorChain = CURRENT.get();
        }
        if (interceptorChain != null) {
            return interceptorChain;
        }
        throw new IllegalStateException("InterceptorChain should have been injected");
    }

    @Override
    public boolean matches(@Nonnull ProcessingContext context) {
        return CURRENT.get() != null || context != null && context.containsResource(INTERCEPTOR_CHAIN_KEY);
    }

    @Override
    @Nullable
    public ParameterResolver<MessageHandlerInterceptorChain<?>> createInstance(@Nonnull Executable executable, @Nonnull Parameter[] parameters, int parameterIndex) {
        if (MessageHandlerInterceptorChain.class.equals(parameters[parameterIndex].getType())) {
            return this;
        }
        return null;
    }
}

