/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import org.axonframework.common.Assert;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.AnnotationUtils;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.annotation.ParameterResolverFactory;

public abstract class AbstractAnnotatedParameterResolverFactory<A extends Annotation, P>
implements ParameterResolverFactory {
    private final Class<A> annotationType;
    private final Class<P> declaredParameterType;

    protected AbstractAnnotatedParameterResolverFactory(Class<A> annotationType, Class<P> declaredParameterType) {
        Assert.notNull(annotationType, () -> "annotationType may not be null");
        Assert.notNull(declaredParameterType, () -> "declaredParameterType may not be null");
        this.annotationType = annotationType;
        this.declaredParameterType = declaredParameterType;
    }

    protected abstract ParameterResolver<P> getResolver();

    @Override
    @Nullable
    public ParameterResolver<P> createInstance(@Nonnull Executable executable, @Nonnull Parameter[] parameters, int parameterIndex) {
        if (AnnotationUtils.isAnnotationPresent((AnnotatedElement)parameters[parameterIndex], this.annotationType)) {
            Class<P> parameterType = parameters[parameterIndex].getType();
            if (parameterType.isAssignableFrom(this.declaredParameterType)) {
                return this.getResolver();
            }
            if (parameterType.isPrimitive() && ReflectionUtils.resolvePrimitiveWrapperType(parameterType).isAssignableFrom(this.declaredParameterType)) {
                return this.getResolver();
            }
        }
        return null;
    }
}

