/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import java.util.Map;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MetaData;

public abstract class AbstractMessage
implements Message {
    private final String identifier;
    private final MessageType type;

    public AbstractMessage(@Nonnull String identifier, @Nonnull MessageType type) {
        this.identifier = identifier;
        this.type = type;
    }

    @Override
    @Nonnull
    public String identifier() {
        return this.identifier;
    }

    @Override
    @Nonnull
    public MessageType type() {
        return this.type;
    }

    @Override
    @Nonnull
    public Message withMetaData(@Nonnull Map<String, String> metaData) {
        if (this.metaData().equals(metaData)) {
            return this;
        }
        return this.withMetaData(MetaData.from(metaData));
    }

    @Override
    @Nonnull
    public Message andMetaData(@Nonnull Map<String, String> metaData) {
        if (metaData.isEmpty()) {
            return this;
        }
        return this.withMetaData(this.metaData().mergedWith(metaData));
    }

    protected abstract Message withMetaData(MetaData var1);
}

