/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.scheduling.quartz;

import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.scheduling.quartz.EventJobDataBinder;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.unitofwork.LegacyDefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FireEventJob
implements Job {
    private static final Logger logger = LoggerFactory.getLogger(FireEventJob.class);
    public static final String EVENT_JOB_DATA_BINDER_KEY = EventJobDataBinder.class.getName();
    public static final String EVENT_BUS_KEY = EventBus.class.getName();
    public static final String TRANSACTION_MANAGER_KEY = TransactionManager.class.getName();
    public static final String MESSAGE_TYPE_RESOLVER_KEY = MessageTypeResolver.class.getName();

    public void execute(JobExecutionContext context) throws JobExecutionException {
        logger.debug("Starting job to publish a scheduled event");
        JobDetail jobDetail = context.getJobDetail();
        JobDataMap jobData = jobDetail.getJobDataMap();
        try {
            SchedulerContext schedulerContext = context.getScheduler().getContext();
            EventJobDataBinder jobDataBinder = (EventJobDataBinder)schedulerContext.get((Object)EVENT_JOB_DATA_BINDER_KEY);
            Object event = jobDataBinder.fromJobData(jobData);
            MessageTypeResolver messageTypeResolver = (MessageTypeResolver)schedulerContext.get((Object)MESSAGE_TYPE_RESOLVER_KEY);
            EventMessage eventMessage = this.createMessage(event, messageTypeResolver);
            EventBus eventBus = (EventBus)schedulerContext.get((Object)EVENT_BUS_KEY);
            TransactionManager txManager = (TransactionManager)schedulerContext.get((Object)TRANSACTION_MANAGER_KEY);
            LegacyDefaultUnitOfWork<Object> unitOfWork = LegacyDefaultUnitOfWork.startAndGet(null);
            if (txManager != null) {
                unitOfWork.attachTransaction(txManager);
            }
            unitOfWork.execute((ProcessingContext ctx) -> eventBus.publish(eventMessage));
            if (logger.isInfoEnabled()) {
                logger.info("Job successfully executed. Scheduled Event [{}] has been published.", (Object)eventMessage.type().name());
            }
        }
        catch (Exception e) {
            logger.error("Exception occurred while publishing scheduled event [{}]", (Object)jobDetail.getDescription(), (Object)e);
            throw new JobExecutionException((Throwable)e);
        }
    }

    private EventMessage createMessage(Object event, MessageTypeResolver messageTypeResolver) {
        return event instanceof EventMessage ? new GenericEventMessage(((EventMessage)event).type(), ((EventMessage)event).payload(), ((EventMessage)event).metaData()) : new GenericEventMessage(messageTypeResolver.resolveOrThrow(event), event);
    }
}

