/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter.jpa;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.deadletter.jpa.DeadLetterEntry;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.deadletter.Cause;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.GenericDeadLetter;
import org.axonframework.messaging.deadletter.ThrowableCause;

public class JpaDeadLetter<M extends EventMessage>
implements DeadLetter<M> {
    private final String id;
    private final Long index;
    private final String sequenceIdentifier;
    private final Instant enqueuedAt;
    private final Instant lastTouched;
    private final Cause cause;
    private final MetaData diagnostics;
    private final M message;

    public JpaDeadLetter(DeadLetterEntry entry, MetaData diagnostics, M message) {
        this.id = entry.getDeadLetterId();
        this.index = entry.getSequenceIndex();
        this.enqueuedAt = entry.getEnqueuedAt();
        this.lastTouched = entry.getLastTouched();
        this.sequenceIdentifier = entry.getSequenceIdentifier();
        this.cause = entry.getCauseType() != null ? new ThrowableCause(entry.getCauseType(), entry.getCauseMessage()) : null;
        this.diagnostics = diagnostics;
        this.message = message;
    }

    JpaDeadLetter(String id, Long index, String sequenceIdentifier, Instant enqueuedAt, Instant lastTouched, Cause cause, MetaData diagnostics, M message) {
        this.id = id;
        this.index = index;
        this.sequenceIdentifier = sequenceIdentifier;
        this.enqueuedAt = enqueuedAt;
        this.lastTouched = lastTouched;
        this.cause = cause;
        this.diagnostics = diagnostics;
        this.message = message;
    }

    @Override
    public M message() {
        return this.message;
    }

    @Override
    public Optional<Cause> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public Instant enqueuedAt() {
        return this.enqueuedAt;
    }

    @Override
    public Instant lastTouched() {
        return this.lastTouched;
    }

    @Override
    public MetaData diagnostics() {
        return this.diagnostics;
    }

    public String getId() {
        return this.id;
    }

    public Long getIndex() {
        return this.index;
    }

    public String getSequenceIdentifier() {
        return this.sequenceIdentifier;
    }

    @Override
    public DeadLetter<M> markTouched() {
        return new JpaDeadLetter<M>(this.id, this.index, this.sequenceIdentifier, this.enqueuedAt, GenericDeadLetter.clock.instant(), this.cause, this.diagnostics, this.message);
    }

    @Override
    public DeadLetter<M> withCause(Throwable requeueCause) {
        return new JpaDeadLetter<M>(this.id, this.index, this.sequenceIdentifier, this.enqueuedAt, GenericDeadLetter.clock.instant(), requeueCause != null ? ThrowableCause.asCause(requeueCause) : this.cause, this.diagnostics, this.message);
    }

    @Override
    public DeadLetter<M> withDiagnostics(MetaData diagnostics) {
        return new JpaDeadLetter<M>(this.id, this.index, this.sequenceIdentifier, this.enqueuedAt, GenericDeadLetter.clock.instant(), this.cause, diagnostics, this.message);
    }

    public String toString() {
        return "JpaDeadLetter{id='" + this.id + "', index=" + this.index + ", sequenceIdentifier='" + this.sequenceIdentifier + "', enqueuedAt=" + String.valueOf(this.enqueuedAt) + ", lastTouched=" + String.valueOf(this.lastTouched) + ", cause=" + String.valueOf(this.cause) + ", diagnostics=" + String.valueOf(this.diagnostics) + ", message=" + String.valueOf(this.message) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JpaDeadLetter that = (JpaDeadLetter)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        if (!this.index.equals(that.index)) {
            return false;
        }
        if (!this.sequenceIdentifier.equals(that.sequenceIdentifier)) {
            return false;
        }
        if (!this.enqueuedAt.equals(that.enqueuedAt)) {
            return false;
        }
        if (!this.lastTouched.equals(that.lastTouched)) {
            return false;
        }
        if (!Objects.equals(this.cause, that.cause)) {
            return false;
        }
        if (!Objects.equals(this.diagnostics, that.diagnostics)) {
            return false;
        }
        return Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.index.hashCode();
        result = 31 * result + this.sequenceIdentifier.hashCode();
        result = 31 * result + this.enqueuedAt.hashCode();
        result = 31 * result + this.lastTouched.hashCode();
        result = 31 * result + (this.cause != null ? this.cause.hashCode() : 0);
        result = 31 * result + (this.diagnostics != null ? this.diagnostics.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        return result;
    }
}

