/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter.jpa;

import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Lob;
import java.util.Arrays;
import java.util.Objects;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.SimpleSerializedObject;

@Embeddable
public class DeadLetterEventEntry {
    @Basic(optional=false)
    private String eventType;
    @Column(nullable=false)
    private String eventIdentifier;
    @Column(nullable=false)
    private String type;
    @Basic(optional=false)
    private String timeStamp;
    @Basic(optional=false)
    private String payloadType;
    @Basic
    private String payloadRevision;
    @Basic(optional=false)
    @Lob
    @Column(length=10000)
    private byte[] payload;
    @Basic
    @Lob
    @Column(length=10000)
    private byte[] metaData;
    @Basic
    private String aggregateType;
    @Basic
    private String aggregateIdentifier;
    @Basic
    private Long sequenceNumber;
    @Basic
    private String tokenType;
    @Basic
    @Lob
    @Column(length=10000)
    private byte[] token;

    protected DeadLetterEventEntry() {
    }

    public DeadLetterEventEntry(String eventType, String eventIdentifier, String type, String messageTimestamp, String payloadType, String payloadRevision, byte[] payload, byte[] metaData, String aggregateType, String aggregateIdentifier, Long sequenceNumber, String tokenType, byte[] token) {
        Objects.requireNonNull(eventType, "Event type should be provided by the DeadLetterJpaConverter, otherwise it can never be converted back.");
        Objects.requireNonNull(eventIdentifier, "All EventMessage implementations require a message identifier.");
        Objects.requireNonNull(type, "All EventMessage implementations require a type.");
        Objects.requireNonNull(messageTimestamp, "All EventMessage implementations require a timestamp.");
        this.eventType = eventType;
        this.eventIdentifier = eventIdentifier;
        this.type = type;
        this.timeStamp = messageTimestamp;
        this.payloadType = payloadType;
        this.payloadRevision = payloadRevision;
        this.payload = payload;
        this.metaData = metaData;
        this.aggregateType = aggregateType;
        this.aggregateIdentifier = aggregateIdentifier;
        this.sequenceNumber = sequenceNumber;
        this.tokenType = tokenType;
        this.token = token;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getEventIdentifier() {
        return this.eventIdentifier;
    }

    public String getType() {
        return this.type;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public SimpleSerializedObject<byte[]> getPayload() {
        return new SimpleSerializedObject<byte[]>(this.payload, byte[].class, this.payloadType, this.payloadRevision);
    }

    public SimpleSerializedObject<byte[]> getMetaData() {
        return new SimpleSerializedObject<byte[]>(this.metaData, byte[].class, MetaData.class.getName(), null);
    }

    public String getAggregateType() {
        return this.aggregateType;
    }

    public String getAggregateIdentifier() {
        return this.aggregateIdentifier;
    }

    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public SimpleSerializedObject<byte[]> getTrackingToken() {
        if (this.token == null) {
            return null;
        }
        return new SimpleSerializedObject<byte[]>(this.token, byte[].class, this.tokenType, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeadLetterEventEntry that = (DeadLetterEventEntry)o;
        return Objects.equals(this.eventType, that.eventType) && Objects.equals(this.eventIdentifier, that.eventIdentifier) && Objects.equals(this.type, that.type) && Objects.equals(this.timeStamp, that.timeStamp) && Objects.equals(this.payloadType, that.payloadType) && Objects.equals(this.payloadRevision, that.payloadRevision) && Objects.deepEquals(this.payload, that.payload) && Objects.deepEquals(this.metaData, that.metaData) && Objects.equals(this.aggregateType, that.aggregateType) && Objects.equals(this.aggregateIdentifier, that.aggregateIdentifier) && Objects.equals(this.sequenceNumber, that.sequenceNumber) && Objects.equals(this.tokenType, that.tokenType) && Objects.deepEquals(this.token, that.token);
    }

    public int hashCode() {
        return Objects.hash(this.eventType, this.eventIdentifier, this.type, this.timeStamp, this.payloadType, this.payloadRevision, Arrays.hashCode(this.payload), Arrays.hashCode(this.metaData), this.aggregateType, this.aggregateIdentifier, this.sequenceNumber, this.tokenType, Arrays.hashCode(this.token));
    }

    public String toString() {
        return "DeadLetterEventEntry{eventType='" + this.eventType + "', eventIdentifier='" + this.eventIdentifier + "', type='" + this.type + "', timeStamp='" + this.timeStamp + "', payloadType='" + this.payloadType + "', payloadRevision='" + this.payloadRevision + "', payload=" + Arrays.toString(this.payload) + ", metaData=" + Arrays.toString(this.metaData) + ", aggregateType='" + this.aggregateType + "', aggregateIdentifier='" + this.aggregateIdentifier + "', sequenceNumber=" + this.sequenceNumber + ", tokenType='" + this.tokenType + "', token=" + Arrays.toString(this.token) + "}";
    }
}

