/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter.jdbc;

import jakarta.annotation.Nonnull;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.common.ObjectUtils;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.deadletter.jdbc.DeadLetterSchema;
import org.axonframework.eventhandling.deadletter.jdbc.DeadLetterStatementFactory;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.deadletter.Cause;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;

public class DefaultDeadLetterStatementFactory<E extends EventMessage>
implements DeadLetterStatementFactory<E> {
    private final DeadLetterSchema schema;
    private final Serializer genericSerializer;
    private final Serializer eventSerializer;

    protected DefaultDeadLetterStatementFactory(Builder<E> builder) {
        builder.validate();
        this.schema = builder.schema;
        this.genericSerializer = builder.genericSerializer;
        this.eventSerializer = builder.eventSerializer;
    }

    public static <E extends EventMessage> Builder<E> builder() {
        return new Builder();
    }

    @Override
    public PreparedStatement enqueueStatement(@Nonnull Connection connection, @Nonnull String processingGroup, @Nonnull String sequenceIdentifier, @Nonnull DeadLetter<? extends E> letter, long sequenceIndex) throws SQLException {
        String sql = "INSERT INTO " + this.schema.deadLetterTable() + " (" + this.schema.deadLetterFields() + ") VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement statement = connection.prepareStatement(sql);
        AtomicInteger fieldIndex = new AtomicInteger(1);
        EventMessage eventMessage = (EventMessage)letter.message();
        this.setIdFields(statement, fieldIndex, processingGroup, sequenceIdentifier, sequenceIndex);
        this.setEventFields(statement, fieldIndex, eventMessage);
        this.setDomainEventFields(statement, fieldIndex, eventMessage);
        this.setTrackedEventFields(statement, fieldIndex, eventMessage);
        this.setDeadLetterFields(statement, fieldIndex, letter);
        return statement;
    }

    private void setIdFields(PreparedStatement statement, AtomicInteger fieldIndex, String processingGroup, String sequenceIdentifier, long sequenceIndex) throws SQLException {
        String deadLetterId = IdentifierFactory.getInstance().generateIdentifier();
        statement.setString(fieldIndex.getAndIncrement(), deadLetterId);
        statement.setString(fieldIndex.getAndIncrement(), processingGroup);
        statement.setString(fieldIndex.getAndIncrement(), sequenceIdentifier);
        statement.setLong(fieldIndex.getAndIncrement(), sequenceIndex);
    }

    private void setEventFields(PreparedStatement statement, AtomicInteger fieldIndex, E eventMessage) throws SQLException {
        SerializedObject<byte[]> serializedPayload = this.eventSerializer.serialize(eventMessage.payload(), byte[].class);
        SerializedObject<byte[]> serializedMetaData = this.eventSerializer.serialize(eventMessage.metaData(), byte[].class);
        statement.setString(fieldIndex.getAndIncrement(), eventMessage.getClass().getName());
        statement.setString(fieldIndex.getAndIncrement(), eventMessage.identifier());
        statement.setString(fieldIndex.getAndIncrement(), eventMessage.type().toString());
        statement.setString(fieldIndex.getAndIncrement(), DateTimeUtils.formatInstant(eventMessage.timestamp()));
        statement.setString(fieldIndex.getAndIncrement(), serializedPayload.getType().getName());
        statement.setString(fieldIndex.getAndIncrement(), serializedPayload.getType().getRevision());
        statement.setBytes(fieldIndex.getAndIncrement(), serializedPayload.getData());
        statement.setBytes(fieldIndex.getAndIncrement(), serializedMetaData.getData());
    }

    private void setDomainEventFields(PreparedStatement statement, AtomicInteger fieldIndex, EventMessage eventMessage) throws SQLException {
        boolean isDomainEvent = eventMessage instanceof DomainEventMessage;
        this.setDomainEventFields(statement, fieldIndex, isDomainEvent ? (DomainEventMessage)eventMessage : null);
    }

    private void setDomainEventFields(PreparedStatement statement, AtomicInteger fieldIndex, DomainEventMessage eventMessage) throws SQLException {
        statement.setString(fieldIndex.getAndIncrement(), ObjectUtils.getOrDefault(eventMessage, DomainEventMessage::getType, null));
        statement.setString(fieldIndex.getAndIncrement(), ObjectUtils.getOrDefault(eventMessage, DomainEventMessage::getAggregateIdentifier, null));
        statement.setLong(fieldIndex.getAndIncrement(), ObjectUtils.getOrDefault(eventMessage, DomainEventMessage::getSequenceNumber, -1L));
    }

    private void setTrackedEventFields(PreparedStatement statement, AtomicInteger fieldIndex, EventMessage eventMessage) throws SQLException {
        boolean isTrackedEvent = eventMessage instanceof TrackedEventMessage;
        this.setTrackedEventFields(statement, fieldIndex, isTrackedEvent ? ((TrackedEventMessage)eventMessage).trackingToken() : null);
    }

    private void setTrackedEventFields(PreparedStatement statement, AtomicInteger fieldIndex, TrackingToken token) throws SQLException {
        if (token != null) {
            SerializedObject<byte[]> serializedToken = this.genericSerializer.serialize(token, byte[].class);
            statement.setString(fieldIndex.getAndIncrement(), serializedToken.getType().getName());
            statement.setBytes(fieldIndex.getAndIncrement(), serializedToken.getData());
        } else {
            statement.setString(fieldIndex.getAndIncrement(), null);
            statement.setBytes(fieldIndex.getAndIncrement(), null);
        }
    }

    private void setDeadLetterFields(PreparedStatement statement, AtomicInteger fieldIndex, DeadLetter<? extends E> letter) throws SQLException {
        statement.setString(fieldIndex.getAndIncrement(), DateTimeUtils.formatInstant(letter.enqueuedAt()));
        statement.setString(fieldIndex.getAndIncrement(), DateTimeUtils.formatInstant(letter.lastTouched()));
        Optional<Cause> cause = letter.cause();
        statement.setString(fieldIndex.getAndIncrement(), cause.map(Cause::type).orElse(null));
        statement.setString(fieldIndex.getAndIncrement(), cause.map(Cause::message).orElse(null));
        SerializedObject<byte[]> serializedDiagnostics = this.eventSerializer.serialize(letter.diagnostics(), byte[].class);
        statement.setBytes(fieldIndex.getAndIncrement(), serializedDiagnostics.getData());
    }

    @Override
    public PreparedStatement maxIndexStatement(@Nonnull Connection connection, @Nonnull String processingGroup, @Nonnull String sequenceId) throws SQLException {
        String sql = "SELECT MAX(" + this.schema.sequenceIndexColumn() + ") FROM " + this.schema.deadLetterTable() + " WHERE " + this.schema.processingGroupColumn() + "=? AND " + this.schema.sequenceIdentifierColumn() + "=?";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setString(1, processingGroup);
        statement.setString(2, sequenceId);
        return statement;
    }

    @Override
    public PreparedStatement evictStatement(@Nonnull Connection connection, @Nonnull String identifier) throws SQLException {
        String sql = "DELETE FROM " + this.schema.deadLetterTable() + " WHERE " + this.schema.deadLetterIdentifierColumn() + "=?";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setString(1, identifier);
        return statement;
    }

    @Override
    public PreparedStatement requeueStatement(@Nonnull Connection connection, @Nonnull String letterIdentifier, Cause cause, @Nonnull Instant lastTouched, MetaData diagnostics) throws SQLException {
        String sql = "UPDATE " + this.schema.deadLetterTable() + " SET " + this.schema.causeTypeColumn() + "=?, " + this.schema.causeMessageColumn() + "=?, " + this.schema.lastTouchedColumn() + "=?, " + this.schema.diagnosticsColumn() + "=?, " + this.schema.processingStartedColumn() + "=NULL WHERE " + this.schema.deadLetterIdentifierColumn() + "=?";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setString(1, ObjectUtils.getOrDefault(cause, Cause::type, null));
        statement.setString(2, ObjectUtils.getOrDefault(cause, Cause::message, null));
        statement.setString(3, DateTimeUtils.formatInstant(lastTouched));
        SerializedObject<byte[]> serializedDiagnostics = this.eventSerializer.serialize(diagnostics, byte[].class);
        statement.setBytes(4, serializedDiagnostics.getData());
        statement.setString(5, letterIdentifier);
        return statement;
    }

    @Override
    public PreparedStatement containsStatement(@Nonnull Connection connection, @Nonnull String processingGroup, @Nonnull String sequenceId) throws SQLException {
        return this.sequenceSizeStatement(connection, processingGroup, sequenceId);
    }

    @Override
    public PreparedStatement letterSequenceStatement(@Nonnull Connection connection, @Nonnull String processingGroup, @Nonnull String sequenceId, int offset, int maxSize) throws SQLException {
        String sql = "SELECT * FROM " + this.schema.deadLetterTable() + " WHERE " + this.schema.processingGroupColumn() + "=? AND " + this.schema.sequenceIdentifierColumn() + "=? AND " + this.schema.sequenceIndexColumn() + ">=? ORDER BY " + this.schema.sequenceIndexColumn() + " LIMIT ?";
        PreparedStatement statement = connection.prepareStatement(sql, 1003, 1007);
        statement.setString(1, processingGroup);
        statement.setString(2, sequenceId);
        statement.setInt(3, offset);
        statement.setInt(4, maxSize);
        return statement;
    }

    @Override
    public PreparedStatement sequenceIdentifiersStatement(@Nonnull Connection connection, @Nonnull String processingGroup) throws SQLException {
        String sql = "SELECT dl." + this.schema.sequenceIdentifierColumn() + " FROM " + this.schema.deadLetterTable() + " dl WHERE dl." + this.schema.processingGroupColumn() + "=? AND dl." + this.schema.sequenceIndexColumn() + "=(SELECT MIN(dl2." + this.schema.sequenceIndexColumn() + ") FROM " + this.schema.deadLetterTable() + " dl2 WHERE dl2." + this.schema.processingGroupColumn() + "=dl." + this.schema.processingGroupColumn() + " AND dl2." + this.schema.sequenceIdentifierColumn() + "=dl." + this.schema.sequenceIdentifierColumn() + ") ORDER BY dl." + this.schema.lastTouchedColumn() + " ASC";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setString(1, processingGroup);
        return statement;
    }

    @Override
    public PreparedStatement sizeStatement(@Nonnull Connection connection, @Nonnull String processingGroup) throws SQLException {
        String sql = "SELECT COUNT(*) FROM " + this.schema.deadLetterTable() + " WHERE " + this.schema.processingGroupColumn() + "=?";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setString(1, processingGroup);
        return statement;
    }

    @Override
    public PreparedStatement sequenceSizeStatement(@Nonnull Connection connection, @Nonnull String processingGroup, @Nonnull String sequenceId) throws SQLException {
        String sql = "SELECT COUNT(*) FROM " + this.schema.deadLetterTable() + " WHERE " + this.schema.processingGroupColumn() + "=? AND " + this.schema.sequenceIdentifierColumn() + "=?";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setString(1, processingGroup);
        statement.setString(2, sequenceId);
        return statement;
    }

    @Override
    public PreparedStatement amountOfSequencesStatement(@Nonnull Connection connection, @Nonnull String processingGroup) throws SQLException {
        String sql = "SELECT COUNT(DISTINCT " + this.schema.sequenceIdentifierColumn() + ") FROM " + this.schema.deadLetterTable() + " WHERE " + this.schema.processingGroupColumn() + "=?";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setString(1, processingGroup);
        return statement;
    }

    @Override
    public PreparedStatement claimableSequencesStatement(@Nonnull Connection connection, @Nonnull String processingGroup, @Nonnull Instant processingStartedLimit, int offset, int maxSize) throws SQLException {
        String sql = "SELECT * FROM " + this.schema.deadLetterTable() + " dl WHERE dl." + this.schema.processingGroupColumn() + "=? AND dl." + this.schema.sequenceIndexColumn() + ">=? AND dl." + this.schema.sequenceIndexColumn() + "=(SELECT MIN(dl2." + this.schema.sequenceIndexColumn() + ") FROM " + this.schema.deadLetterTable() + " dl2 WHERE dl2." + this.schema.processingGroupColumn() + "=dl." + this.schema.processingGroupColumn() + " AND dl2." + this.schema.sequenceIdentifierColumn() + "=dl." + this.schema.sequenceIdentifierColumn() + ") AND (dl." + this.schema.processingStartedColumn() + " IS NULL OR dl." + this.schema.processingStartedColumn() + "<?) ORDER BY dl." + this.schema.lastTouchedColumn() + " ASC LIMIT ?";
        PreparedStatement statement = connection.prepareStatement(sql, 1003, 1007);
        statement.setString(1, processingGroup);
        statement.setInt(2, offset);
        statement.setString(3, DateTimeUtils.formatInstant(processingStartedLimit));
        statement.setInt(4, maxSize);
        return statement;
    }

    @Override
    public PreparedStatement claimStatement(@Nonnull Connection connection, @Nonnull String identifier, @Nonnull Instant current, @Nonnull Instant processingStartedLimit) throws SQLException {
        String sql = "UPDATE " + this.schema.deadLetterTable() + " SET " + this.schema.processingStartedColumn() + "=? WHERE " + this.schema.deadLetterIdentifierColumn() + "=? AND (" + this.schema.processingStartedColumn() + " IS NULL OR " + this.schema.processingStartedColumn() + "<?)";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setString(1, DateTimeUtils.formatInstant(current));
        statement.setString(2, identifier);
        statement.setString(3, DateTimeUtils.formatInstant(processingStartedLimit));
        return statement;
    }

    @Override
    public PreparedStatement nextLetterInSequenceStatement(@Nonnull Connection connection, @Nonnull String processingGroup, @Nonnull String sequenceIdentifier, long sequenceIndex) throws SQLException {
        String sql = "SELECT * FROM " + this.schema.deadLetterTable() + " WHERE " + this.schema.processingGroupColumn() + "=? AND " + this.schema.sequenceIdentifierColumn() + "=? AND " + this.schema.sequenceIndexColumn() + ">? ORDER BY " + this.schema.sequenceIndexColumn() + " ASC LIMIT 1";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setString(1, processingGroup);
        statement.setString(2, sequenceIdentifier);
        statement.setLong(3, sequenceIndex);
        return statement;
    }

    @Override
    public PreparedStatement clearStatement(@Nonnull Connection connection, @Nonnull String processingGroup) throws SQLException {
        String sql = "DELETE FROM " + this.schema.deadLetterTable() + " WHERE " + this.schema.processingGroupColumn() + "=?";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setString(1, processingGroup);
        return statement;
    }

    protected static class Builder<E extends EventMessage> {
        private DeadLetterSchema schema = DeadLetterSchema.defaultSchema();
        private Serializer genericSerializer;
        private Serializer eventSerializer;

        protected Builder() {
        }

        public Builder<E> schema(DeadLetterSchema schema) {
            BuilderUtils.assertNonNull(schema, "DeadLetterSchema may not be null");
            this.schema = schema;
            return this;
        }

        public Builder<E> genericSerializer(Serializer genericSerializer) {
            BuilderUtils.assertNonNull(genericSerializer, "The generic serializer may not be null");
            this.genericSerializer = genericSerializer;
            return this;
        }

        public Builder<E> eventSerializer(Serializer eventSerializer) {
            BuilderUtils.assertNonNull(eventSerializer, "The event serializer may not be null");
            this.eventSerializer = eventSerializer;
            return this;
        }

        public DefaultDeadLetterStatementFactory<E> build() {
            return new DefaultDeadLetterStatementFactory(this);
        }

        protected void validate() {
            BuilderUtils.assertNonNull(this.genericSerializer, "The generic Serializer is a hard requirement and should be provided");
            BuilderUtils.assertNonNull(this.eventSerializer, "The event Serializer is a hard requirement and should be provided");
        }
    }
}

