/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.conversion;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.Objects;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.conversion.EventConverter;
import org.axonframework.messaging.conversion.DelegatingMessageConverter;
import org.axonframework.messaging.conversion.MessageConverter;
import org.axonframework.serialization.Converter;

public class DelegatingEventConverter
implements EventConverter {
    private final MessageConverter delegate;

    public DelegatingEventConverter(@Nonnull Converter converter) {
        MessageConverter messageConverter;
        if (converter instanceof MessageConverter) {
            MessageConverter messageConverter2 = (MessageConverter)converter;
            messageConverter = messageConverter2;
        } else {
            messageConverter = new DelegatingMessageConverter(converter);
        }
        this(messageConverter);
    }

    public DelegatingEventConverter(@Nonnull MessageConverter delegate) {
        this.delegate = Objects.requireNonNull(delegate, "The Converter must not be null.");
    }

    @Override
    public boolean canConvert(@Nonnull Type sourceType, @Nonnull Type targetType) {
        return this.delegate.canConvert(sourceType, targetType);
    }

    @Override
    @Nullable
    public <T> T convert(@Nullable Object input, @Nonnull Type targetType) {
        return this.delegate.convert(input, targetType);
    }

    @Override
    @Nullable
    public <E extends EventMessage, T> T convertPayload(@Nonnull E event, @Nonnull Type targetType) {
        return this.delegate.convertPayload(event, targetType);
    }

    @Override
    @Nonnull
    public <E extends EventMessage> E convertEvent(@Nonnull E event, @Nonnull Type targetType) {
        return this.delegate.convertMessage(event, targetType);
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("messageConverter", this.delegate);
    }

    @Internal
    public MessageConverter delegate() {
        return this.delegate;
    }
}

