/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventHandlingComponent;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.configuration.DefaultEventHandlingComponentBuilder;
import org.axonframework.eventhandling.configuration.EventHandlingComponentBuilder;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class SimpleEventHandlingComponent
implements EventHandlingComponent {
    private final ConcurrentHashMap<QualifiedName, List<EventHandler>> eventHandlers = new ConcurrentHashMap();

    @Override
    @Nonnull
    public MessageStream.Empty<Message> handle(@Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        QualifiedName name = event.type().qualifiedName();
        List<EventHandler> handlers = this.eventHandlers.get(name);
        if (handlers == null || handlers.isEmpty()) {
            return MessageStream.failed(new IllegalArgumentException("No handler found for event with name [" + String.valueOf(name) + "]"));
        }
        MessageStream<Message> result = MessageStream.empty();
        for (EventHandler handler : handlers) {
            MessageStream.Empty<Message> handlerResult = handler.handle(event, context);
            result = result.concatWith(handlerResult);
        }
        return result.ignoreEntries().cast();
    }

    @Override
    public SimpleEventHandlingComponent subscribe(@Nonnull Set<QualifiedName> names, @Nonnull EventHandler handler) {
        Objects.requireNonNull(handler, "The given handler cannot be null.");
        names.forEach(name -> this.eventHandlers.compute((QualifiedName)name, (q, handlers) -> {
            if (handlers == null) {
                handlers = new CopyOnWriteArrayList<EventHandler>();
            }
            handlers.add(handler);
            return handlers;
        }));
        return this;
    }

    @Override
    public SimpleEventHandlingComponent subscribe(@Nonnull QualifiedName name, @Nonnull EventHandler handler) {
        return this.subscribe((Set)Set.of(name), handler);
    }

    @Override
    public Set<QualifiedName> supportedEvents() {
        return Set.copyOf(this.eventHandlers.keySet());
    }

    @Nonnull
    public static EventHandlingComponentBuilder.SequencingPolicyPhase builder() {
        return new DefaultEventHandlingComponentBuilder(new SimpleEventHandlingComponent());
    }
}

