/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.eventhandling.AnnotationEventHandlerAdapter;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventMessageHandler;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;
import org.axonframework.eventhandling.LoggingErrorHandler;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.SegmentMatcher;
import org.axonframework.eventhandling.async.SequencingPolicy;
import org.axonframework.eventhandling.async.SequentialPerAggregatePolicy;
import org.axonframework.messaging.ClassBasedMessageTypeResolver;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class SimpleEventHandlerInvoker
implements EventHandlerInvoker {
    private final List<EventMessageHandler> eventHandlingComponents;
    private final ListenerInvocationErrorHandler listenerInvocationErrorHandler;
    private final SequencingPolicy sequencingPolicy;
    private final SegmentMatcher segmentMatcher;

    protected SimpleEventHandlerInvoker(Builder<?> builder) {
        builder.validate();
        this.eventHandlingComponents = builder.eventHandlers.stream().map(handler -> handler instanceof EventMessageHandler ? (EventMessageHandler)handler : builder.wrapEventMessageHandler(handler)).collect(Collectors.toCollection(ArrayList::new));
        this.sequencingPolicy = builder.sequencingPolicy;
        this.segmentMatcher = new SegmentMatcher(this.sequencingPolicy);
        this.listenerInvocationErrorHandler = builder.listenerInvocationErrorHandler;
    }

    private static List<?> detectList(Object[] eventHandlers) {
        return eventHandlers.length == 1 && eventHandlers[0] instanceof List ? (List)eventHandlers[0] : Arrays.asList(eventHandlers);
    }

    public static <B extends Builder<?>> Builder<B> builder() {
        return new Builder();
    }

    public List<EventMessageHandler> eventHandlers() {
        return Collections.unmodifiableList(this.eventHandlingComponents);
    }

    @Override
    public void handle(@Nonnull EventMessage message, @Nonnull ProcessingContext context, @Nonnull Segment segment) throws Exception {
        if (!this.sequencingPolicyMatchesSegment(message, segment, context)) {
            return;
        }
        this.invokeHandlers(message, context);
    }

    protected boolean sequencingPolicyMatchesSegment(@Nonnull EventMessage message, @Nonnull Segment segment, @Nonnull ProcessingContext context) {
        return this.segmentMatcher.matches(segment, message, context);
    }

    protected Object sequenceIdentifier(EventMessage event, ProcessingContext context) {
        return this.segmentMatcher.sequenceIdentifier(event, context);
    }

    protected void invokeHandlers(EventMessage message, ProcessingContext context) throws Exception {
        for (EventMessageHandler handler : this.eventHandlingComponents) {
            try {
                handler.handleSync(message, context);
            }
            catch (Exception e) {
                this.listenerInvocationErrorHandler.onError(e, message, handler);
            }
        }
    }

    @Override
    public boolean canHandle(@Nonnull EventMessage eventMessage, @Nonnull ProcessingContext context, @Nonnull Segment segment) {
        return this.hasHandler(eventMessage, context) && this.segmentMatcher.matches(segment, eventMessage, context);
    }

    @Override
    public boolean canHandleType(@Nonnull Class<?> payloadType) {
        return this.eventHandlingComponents.stream().anyMatch(eh -> eh.canHandleType(payloadType));
    }

    private boolean hasHandler(@Nonnull EventMessage eventMessage, @Nonnull ProcessingContext context) {
        for (EventMessageHandler eventHandler : this.eventHandlingComponents) {
            if (!eventHandler.canHandle(eventMessage, context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsReset() {
        return this.eventHandlingComponents.stream().anyMatch(EventMessageHandler::supportsReset);
    }

    @Override
    public void performReset(ProcessingContext context) {
        this.performReset(null, context);
    }

    @Override
    public <R> void performReset(@Nullable R resetContext, ProcessingContext context) {
        for (EventMessageHandler eventHandler : this.eventHandlingComponents) {
            eventHandler.prepareReset(resetContext, context);
        }
    }

    public ListenerInvocationErrorHandler getListenerInvocationErrorHandler() {
        return this.listenerInvocationErrorHandler;
    }

    public SequencingPolicy getSequencingPolicy() {
        return this.sequencingPolicy;
    }

    @Override
    public Set<Class<?>> supportedEventTypes() {
        return this.eventHandlingComponents.stream().flatMap(handler -> handler.supportedEventTypes().stream()).collect(Collectors.toSet());
    }

    public static class Builder<B extends Builder<?>> {
        private List<?> eventHandlers;
        private ParameterResolverFactory parameterResolverFactory;
        private HandlerDefinition handlerDefinition;
        private ListenerInvocationErrorHandler listenerInvocationErrorHandler = new LoggingErrorHandler();
        private SequencingPolicy sequencingPolicy = SequentialPerAggregatePolicy.instance();
        private MessageTypeResolver messageTypeResolver = new ClassBasedMessageTypeResolver();

        public B eventHandlers(Object ... eventHandlers) {
            return this.eventHandlers(SimpleEventHandlerInvoker.detectList(eventHandlers));
        }

        public B eventHandlers(@Nonnull List<?> eventHandlers) {
            BuilderUtils.assertThat(eventHandlers, list -> list != null && !list.isEmpty(), "At least one EventMessageHandler should be provided");
            this.eventHandlers = eventHandlers;
            return (B)this;
        }

        public B parameterResolverFactory(@Nonnull ParameterResolverFactory parameterResolverFactory) {
            BuilderUtils.assertNonNull(parameterResolverFactory, "ParameterResolverFactory may not be null");
            this.parameterResolverFactory = parameterResolverFactory;
            return (B)this;
        }

        public B handlerDefinition(@Nonnull HandlerDefinition handlerDefinition) {
            BuilderUtils.assertNonNull(handlerDefinition, "HandlerDefinition may not be null");
            this.handlerDefinition = handlerDefinition;
            return (B)this;
        }

        public B listenerInvocationErrorHandler(@Nonnull ListenerInvocationErrorHandler listenerInvocationErrorHandler) {
            BuilderUtils.assertNonNull(listenerInvocationErrorHandler, "ListenerInvocationErrorHandler may not be null");
            this.listenerInvocationErrorHandler = listenerInvocationErrorHandler;
            return (B)this;
        }

        public B sequencingPolicy(@Nonnull SequencingPolicy sequencingPolicy) {
            BuilderUtils.assertNonNull(sequencingPolicy, "The SequencingPolicy may not be null");
            this.sequencingPolicy = sequencingPolicy;
            return (B)this;
        }

        public B messageNameResolver(MessageTypeResolver messageTypeResolver) {
            BuilderUtils.assertNonNull(messageTypeResolver, "MessageNameResolver may not be null");
            this.messageTypeResolver = messageTypeResolver;
            return (B)this;
        }

        public SimpleEventHandlerInvoker build() {
            return new SimpleEventHandlerInvoker(this);
        }

        public AnnotationEventHandlerAdapter wrapEventMessageHandler(@Nonnull Object eventHandler) {
            if (this.parameterResolverFactory == null && this.handlerDefinition == null) {
                return new AnnotationEventHandlerAdapter(eventHandler, this.messageTypeResolver);
            }
            if (this.parameterResolverFactory != null && this.handlerDefinition == null) {
                return new AnnotationEventHandlerAdapter(eventHandler, this.parameterResolverFactory, this.messageTypeResolver);
            }
            return new AnnotationEventHandlerAdapter(eventHandler, this.parameterResolverFactory, this.handlerDefinition, this.messageTypeResolver);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertThat(this.eventHandlers, list -> list != null && !list.isEmpty(), "At least one EventMessageHandler should be provided");
        }
    }
}

