/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.axonframework.eventhandling.DelegatingEventHandlingComponent;
import org.axonframework.eventhandling.EventHandlingComponent;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.monitoring.MessageMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringEventHandlingComponent
extends DelegatingEventHandlingComponent {
    private final Logger logger = LoggerFactory.getLogger(MonitoringEventHandlingComponent.class);
    private final MessageMonitor<? super EventMessage> messageMonitor;

    public MonitoringEventHandlingComponent(@Nonnull MessageMonitor<? super EventMessage> messageMonitor, @Nonnull EventHandlingComponent delegate) {
        super(delegate);
        this.messageMonitor = Objects.requireNonNull(messageMonitor, "MessageMonitor may not be null");
    }

    @Override
    @Nonnull
    public MessageStream.Empty<Message> handle(@Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        MessageMonitor.MonitorCallback monitorCallback = this.messageMonitor.onMessageIngested(event);
        return this.delegate.handle(event, context).whenComplete(() -> {
            try {
                monitorCallback.reportSuccess();
            }
            catch (Exception e) {
                this.logger.warn("An exception occurred while reporting success of event handling", (Throwable)e);
            }
        }).onErrorContinue(ex -> {
            try {
                monitorCallback.reportFailure((Throwable)ex);
            }
            catch (Exception e) {
                this.logger.warn("An exception occurred while reporting failure of event handling", (Throwable)e);
            }
            return MessageStream.failed(ex);
        }).ignoreEntries().cast();
    }
}

