/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.axonframework.common.AxonThreadFactory;
import org.axonframework.common.BuilderUtils;
import org.axonframework.util.ExecutorServiceFactory;

public record DistributedCommandBusConfiguration(int loadFactor, int numberOfThreads, @Nonnull ExecutorServiceFactory<DistributedCommandBusConfiguration> executorServiceFactory) {
    private static final int DEFAULT_LOAD_FACTOR = 100;
    private static final int DEFAULT_NUMBER_OF_THREADS = 10;
    private static final ExecutorServiceFactory<DistributedCommandBusConfiguration> DEFAULT_EXECUTOR_SERVICE_FACTORY = (configuration, commandProcessQueue) -> new ThreadPoolExecutor(configuration.numberOfThreads(), configuration.numberOfThreads(), 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)commandProcessQueue, new AxonThreadFactory("Command"));
    public static final DistributedCommandBusConfiguration DEFAULT = new DistributedCommandBusConfiguration(100, 10, DEFAULT_EXECUTOR_SERVICE_FACTORY);

    public DistributedCommandBusConfiguration {
        BuilderUtils.assertStrictPositive(loadFactor, "Load factor must be greater than 0");
        BuilderUtils.assertStrictPositive(numberOfThreads, "Number of threads must be greater than 0");
    }

    public DistributedCommandBusConfiguration loadFactor(int loadFactor) {
        return new DistributedCommandBusConfiguration(loadFactor, this.numberOfThreads, this.executorServiceFactory);
    }

    public DistributedCommandBusConfiguration numberOfThreads(int numberOfThreads) {
        return new DistributedCommandBusConfiguration(this.loadFactor, numberOfThreads, this.executorServiceFactory);
    }

    public DistributedCommandBusConfiguration executorService(@Nonnull ExecutorService executorService) {
        Objects.requireNonNull(executorService, "The ExecutorService may not be null.");
        return new DistributedCommandBusConfiguration(this.loadFactor, this.numberOfThreads, (config, queue) -> executorService);
    }
}

