/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandHandlerRegistry;
import org.axonframework.commandhandling.CommandHandlingComponent;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.common.Assert;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class SimpleCommandHandlingComponent
implements CommandHandlingComponent,
CommandHandlerRegistry<SimpleCommandHandlingComponent>,
DescribableComponent {
    private final String name;
    private final Map<QualifiedName, CommandHandler> commandHandlers = new HashMap<QualifiedName, CommandHandler>();
    private final Set<CommandHandlingComponent> subComponents = new HashSet<CommandHandlingComponent>();

    public static SimpleCommandHandlingComponent create(@Nonnull String name) {
        return new SimpleCommandHandlingComponent(name);
    }

    private SimpleCommandHandlingComponent(@Nonnull String name) {
        this.name = Assert.nonEmpty(name, "The name may not be null or empty.");
    }

    @Override
    public SimpleCommandHandlingComponent subscribe(@Nonnull QualifiedName name, @Nonnull CommandHandler commandHandler) {
        Objects.requireNonNull(name, "The name of the command handler may not be null");
        Objects.requireNonNull(commandHandler, "The command handler may not be null");
        this.commandHandlers.put(name, commandHandler);
        return this;
    }

    @Override
    public SimpleCommandHandlingComponent subscribe(@Nonnull CommandHandlingComponent commandHandlingComponent) {
        this.subComponents.add(Objects.requireNonNull(commandHandlingComponent, "The command handling component may not be null"));
        return this;
    }

    @Override
    @Nonnull
    public MessageStream.Single<CommandResultMessage<?>> handle(@Nonnull CommandMessage command, @Nonnull ProcessingContext context) {
        QualifiedName qualifiedName = Objects.requireNonNull(command, "The command message cannot be null.").type().qualifiedName();
        Optional<CommandHandlingComponent> optionalSubHandler = this.subComponents.stream().filter(subComponent -> subComponent.supportedCommands().contains(qualifiedName)).findFirst();
        if (optionalSubHandler.isPresent()) {
            try {
                return optionalSubHandler.get().handle(command, context);
            }
            catch (Throwable e) {
                return MessageStream.failed(e);
            }
        }
        if (this.commandHandlers.containsKey(qualifiedName)) {
            try {
                return this.commandHandlers.get(qualifiedName).handle(command, context);
            }
            catch (Throwable e) {
                return MessageStream.failed(e);
            }
        }
        String message = "No handler was subscribed for command with qualified name [%s] on component [%s]. Registered handlers: [%s]".formatted(qualifiedName.fullName(), this.getClass().getName(), this.supportedCommands());
        return MessageStream.failed(new NoHandlerForCommandException(message));
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("name", this.name);
        descriptor.describeProperty("commandHandlers", this.commandHandlers);
        descriptor.describeProperty("subComponents", this.subComponents);
    }

    @Override
    public Set<QualifiedName> supportedCommands() {
        HashSet<QualifiedName> combinedNames = new HashSet<QualifiedName>(this.commandHandlers.keySet());
        this.subComponents.forEach(subComponent -> combinedNames.addAll(subComponent.supportedCommands()));
        return combinedNames;
    }
}

