/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.annotation;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventHandlerRegistry;
import org.axonframework.eventhandling.EventHandlingComponent;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.annotation.AnnotatedHandlerInspector;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandlerInterceptorMemberChain;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class AnnotatedEventHandlingComponent<T>
implements EventHandlingComponent {
    private final T target;
    private final AnnotatedHandlerInspector<T> model;

    public AnnotatedEventHandlingComponent(@Nonnull T annotatedEventHandler) {
        this(annotatedEventHandler, ClasspathParameterResolverFactory.forClass(annotatedEventHandler.getClass()));
    }

    public AnnotatedEventHandlingComponent(@Nonnull T annotatedEventHandler, @Nonnull ParameterResolverFactory parameterResolverFactory) {
        this(annotatedEventHandler, parameterResolverFactory, ClasspathHandlerDefinition.forClass(annotatedEventHandler.getClass()));
    }

    public AnnotatedEventHandlingComponent(@Nonnull T annotatedEventHandler, @Nonnull ParameterResolverFactory parameterResolverFactory, @Nonnull HandlerDefinition handlerDefinition) {
        this(annotatedEventHandler, AnnotatedHandlerInspector.inspectType(annotatedEventHandler.getClass(), parameterResolverFactory, handlerDefinition));
    }

    public AnnotatedEventHandlingComponent(@Nonnull T annotatedEventHandler, @Nonnull AnnotatedHandlerInspector<T> model) {
        this.target = Objects.requireNonNull(annotatedEventHandler, "The Annotated Event Handler may not be null");
        this.model = Objects.requireNonNull(model, "The Annotated Handler Inspector may not be null");
    }

    @Override
    public EventHandlerRegistry subscribe(@Nonnull QualifiedName name, @Nonnull EventHandler eventHandler) {
        throw new UnsupportedOperationException("This Event Handling Component does not support direct event handler registration.");
    }

    @Override
    @Nonnull
    public MessageStream.Empty<Message<Void>> handle(@Nonnull EventMessage<?> event, @Nonnull ProcessingContext context) {
        Objects.requireNonNull(event, "Event Message may not be null");
        Objects.requireNonNull(context, "Processing Context may not be null");
        Class<?> listenerType = this.target.getClass();
        Optional<MessageHandlingMember> handler = this.model.getHandlers(listenerType).filter(h -> h.canHandle(event, context)).findFirst();
        if (handler.isPresent()) {
            MessageHandlerInterceptorMemberChain<T> interceptor = this.model.chainedInterceptor(listenerType);
            MessageStream<?> result = interceptor.handle(event, context, this.target, handler.get());
            return result.ignoreEntries().cast();
        }
        return MessageStream.empty();
    }

    @Override
    public Set<QualifiedName> supportedEvents() {
        Class<?> listenerType = this.target.getClass();
        return this.model.getHandlers(listenerType).filter(Objects::nonNull).map(MessageHandlingMember::payloadType).map(QualifiedName::new).collect(Collectors.toSet());
    }
}

