/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.infra;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.infra.ComponentDescriptorException;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.configuration.Component;

public class JacksonComponentDescriptor
implements ComponentDescriptor {
    private final ObjectMapper objectMapper;
    private final ObjectNode rootNode;
    private final Map<DescribableComponent, String> processedComponents;

    public JacksonComponentDescriptor() {
        this(new ObjectMapper());
    }

    public JacksonComponentDescriptor(ObjectMapper objectMapper) {
        this(objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS), new IdentityHashMap<DescribableComponent, String>());
    }

    private JacksonComponentDescriptor(ObjectMapper objectMapper, Map<DescribableComponent, String> processedComponents) {
        this.objectMapper = objectMapper;
        this.rootNode = objectMapper.createObjectNode();
        this.processedComponents = processedComponents;
    }

    @Override
    public void describeProperty(@Nonnull String name, Object object) {
        JsonNode json = this.describeObject(object);
        this.rootNode.set(name, json);
    }

    private JsonNode describeObject(Object object) {
        if (object instanceof DescribableComponent) {
            boolean componentSeenAlready;
            DescribableComponent component = (DescribableComponent)object;
            String id = this.processedComponents.get(component);
            boolean bl = componentSeenAlready = id != null;
            if (componentSeenAlready) {
                ObjectNode refNode = this.objectMapper.createObjectNode();
                refNode.put("$ref", id);
                JacksonComponentDescriptor.describeType(component, refNode);
                return refNode;
            }
            return this.describeComponentJson(component);
        }
        return this.objectMapper.valueToTree(object);
    }

    private ObjectNode describeComponentJson(DescribableComponent component) {
        String componentId = "" + System.identityHashCode(component);
        this.processedComponents.put(component, componentId);
        JacksonComponentDescriptor nestedDescriptor = new JacksonComponentDescriptor(this.objectMapper, this.processedComponents);
        JacksonComponentDescriptor.describeIdAndType(component, nestedDescriptor);
        component.describeTo(nestedDescriptor);
        return nestedDescriptor.rootNode;
    }

    private static void describeIdAndType(DescribableComponent component, JacksonComponentDescriptor componentDescriptor) {
        componentDescriptor.rootNode.put("_ref", "" + System.identityHashCode(component));
        JacksonComponentDescriptor.describeType(component, componentDescriptor.rootNode);
    }

    private static void describeType(DescribableComponent component, ObjectNode objectNode) {
        String type = component instanceof Component ? ((Component)component).identifier().typeAsClass().getName() : component.getClass().getName();
        objectNode.put("_type", type);
    }

    @Override
    public void describeProperty(@Nonnull String name, Collection<?> collection) {
        if (collection == null) {
            this.rootNode.set(name, null);
            return;
        }
        ArrayNode arrayNode = this.objectMapper.createArrayNode();
        for (Object item : collection) {
            JsonNode json = this.describeObject(item);
            arrayNode.add(json);
        }
        this.rootNode.set(name, (JsonNode)arrayNode);
    }

    @Override
    public void describeProperty(@Nonnull String name, Map<?, ?> map) {
        if (map == null) {
            this.rootNode.set(name, null);
            return;
        }
        ObjectNode mapNode = this.objectMapper.createObjectNode();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            JsonNode json = this.describeObject(value);
            mapNode.set(key, json);
        }
        this.rootNode.set(name, (JsonNode)mapNode);
    }

    @Override
    public void describeProperty(@Nonnull String name, String value) {
        this.rootNode.put(name, value);
    }

    @Override
    public void describeProperty(@Nonnull String name, Long value) {
        this.rootNode.put(name, value);
    }

    @Override
    public void describeProperty(@Nonnull String name, Boolean value) {
        this.rootNode.put(name, value);
    }

    @Override
    public String describe() {
        try {
            return this.objectMapper.writeValueAsString((Object)this.rootNode);
        }
        catch (Exception e) {
            throw new ComponentDescriptorException("Error generating JSON description", e);
        }
    }
}

