/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.axonframework.serialization.ContentTypeConverter;
import org.axonframework.serialization.SerializationException;

public class JsonNodeToObjectNodeConverter
implements ContentTypeConverter<JsonNode, ObjectNode> {
    @Override
    public Class<JsonNode> expectedSourceType() {
        return JsonNode.class;
    }

    @Override
    public Class<ObjectNode> targetType() {
        return ObjectNode.class;
    }

    @Override
    public ObjectNode convert(JsonNode original) {
        JsonNodeType originalNodeType = original.getNodeType();
        if (JsonNodeType.OBJECT.equals((Object)originalNodeType)) {
            return (ObjectNode)original;
        }
        throw new SerializationException("Cannot convert from JsonNode to ObjectNode because the node type is [" + String.valueOf(originalNodeType) + "]");
    }
}

