/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization;

import jakarta.annotation.Nonnull;
import java.util.Map;
import org.axonframework.messaging.AbstractMessage;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.LazyDeserializingObject;
import org.axonframework.serialization.SerializationException;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;

public class SerializedMessage<P>
extends AbstractMessage<P> {
    private final LazyDeserializingObject<P> payload;
    private final LazyDeserializingObject<MetaData> metaData;

    public SerializedMessage(@Nonnull String identifier, @Nonnull SerializedObject<?> serializedPayload, @Nonnull SerializedObject<?> serializedMetaData, @Nonnull Serializer serializer) {
        this(identifier, new MessageType(serializedPayload.getType().getName()), new LazyDeserializingObject(serializedPayload, serializer), new LazyDeserializingObject<MetaData>(serializedMetaData, serializer));
    }

    public SerializedMessage(@Nonnull String identifier, @Nonnull MessageType type, @Nonnull LazyDeserializingObject<P> payload, @Nonnull LazyDeserializingObject<MetaData> metaData) {
        super(identifier, type);
        this.metaData = metaData;
        this.payload = payload;
    }

    private SerializedMessage(@Nonnull SerializedMessage<P> message, @Nonnull LazyDeserializingObject<MetaData> newMetaData) {
        this(message.getIdentifier(), message.type(), message.payload, newMetaData);
    }

    @Override
    public P getPayload() {
        try {
            return this.payload.getObject();
        }
        catch (SerializationException e) {
            throw new SerializationException("Error while deserializing payload of message " + this.getIdentifier(), e);
        }
    }

    @Override
    public MetaData getMetaData() {
        try {
            return this.metaData.getObject();
        }
        catch (SerializationException e) {
            throw new SerializationException("Error while deserializing meta data of message " + this.getIdentifier(), e);
        }
    }

    @Override
    public Class<P> getPayloadType() {
        return this.payload.getType();
    }

    @Override
    protected SerializedMessage<P> withMetaData(MetaData metaData) {
        if (this.getMetaData().equals(metaData)) {
            return this;
        }
        return new SerializedMessage<P>(this, new LazyDeserializingObject<MetaData>(metaData));
    }

    @Override
    public SerializedMessage<P> withMetaData(@Nonnull Map<String, ?> metaData) {
        return (SerializedMessage)super.withMetaData(metaData);
    }

    @Override
    public SerializedMessage<P> andMetaData(@Nonnull Map<String, ?> metaData) {
        return (SerializedMessage)super.andMetaData(metaData);
    }

    @Override
    public <R> SerializedObject<R> serializePayload(Serializer serializer, Class<R> expectedRepresentation) {
        if (serializer.equals(this.payload.getSerializer())) {
            return serializer.getConverter().convert(this.payload.getSerializedObject(), expectedRepresentation);
        }
        return serializer.serialize(this.payload.getObject(), expectedRepresentation);
    }

    @Override
    public <R> SerializedObject<R> serializeMetaData(Serializer serializer, Class<R> expectedRepresentation) {
        if (serializer.equals(this.metaData.getSerializer())) {
            return serializer.getConverter().convert(this.metaData.getSerializedObject(), expectedRepresentation);
        }
        return serializer.serialize(this.metaData.getObject(), expectedRepresentation);
    }

    public boolean isPayloadDeserialized() {
        return this.payload.isDeserialized();
    }

    public boolean isMetaDataDeserialized() {
        return this.metaData.isDeserialized();
    }
}

