/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling.annotation;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Optional;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.UnsupportedHandlerException;
import org.axonframework.messaging.annotation.WrappedMessageHandlingMember;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.annotation.QueryHandlingMember;

public class MethodQueryMessageHandlerDefinition
implements HandlerEnhancerDefinition {
    @Override
    @Nonnull
    public <T> MessageHandlingMember<T> wrapHandler(@Nonnull MessageHandlingMember<T> original) {
        return original.attribute("QueryHandler.queryName").map(queryName -> new MethodQueryMessageHandlingMember(original, (String)queryName)).orElse(original);
    }

    private static class MethodQueryMessageHandlingMember<T>
    extends WrappedMessageHandlingMember<T>
    implements QueryHandlingMember<T> {
        private final String queryName;
        private final Type resultType;

        public MethodQueryMessageHandlingMember(MessageHandlingMember<T> original, String queryNameAttribute) {
            super(original);
            if ("".equals(queryNameAttribute)) {
                queryNameAttribute = original.payloadType().getName();
            }
            this.queryName = queryNameAttribute;
            this.resultType = original.unwrap(Method.class).map(this::queryResultType).orElseThrow(() -> new UnsupportedHandlerException("@QueryHandler annotation can only be put on methods.", original.unwrap(Member.class).orElse(null)));
            if (Void.TYPE.equals(this.resultType)) {
                throw new UnsupportedHandlerException("@QueryHandler annotated methods must not declare void return type", original.unwrap(Member.class).orElse(null));
            }
        }

        @Override
        public Object handleSync(@Nonnull Message<?> message, @Nullable T target) throws Exception {
            Object result = super.handleSync(message, target);
            if (result instanceof Optional) {
                return ((Optional)result).orElse(null);
            }
            return result;
        }

        private Type queryResultType(Method method) {
            if (Void.class.equals(method.getReturnType())) {
                throw new UnsupportedHandlerException("@QueryHandler annotated methods must not declare void return type", method);
            }
            return this.unwrapType(method.getGenericReturnType());
        }

        private Type unwrapType(Type genericReturnType) {
            return this.upperBound(ReflectionUtils.resolvePrimitiveWrapperTypeIfPrimitive(ReflectionUtils.unwrapIfType(genericReturnType, Future.class, Optional.class)));
        }

        private Type upperBound(Type type) {
            if (type instanceof WildcardType) {
                if (((WildcardType)type).getUpperBounds().length == 1) {
                    return ((WildcardType)type).getUpperBounds()[0];
                }
                return Object.class;
            }
            return type;
        }

        @Override
        public boolean canHandle(@Nonnull Message<?> message, ProcessingContext processingContext) {
            return super.canHandle(message, processingContext) && message instanceof QueryMessage && this.queryName.equals(message.type().name()) && ((QueryMessage)message).getResponseType().matches(this.resultType);
        }

        @Override
        public String getQueryName() {
            return this.queryName;
        }

        @Override
        public Type getResultType() {
            return this.resultType;
        }
    }
}

