/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptorSupport;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.queryhandling.GenericSubscriptionQueryUpdateMessage;
import org.axonframework.queryhandling.SubscriptionQueryMessage;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.queryhandling.UpdateHandlerRegistration;

public interface QueryUpdateEmitter
extends MessageDispatchInterceptorSupport<SubscriptionQueryUpdateMessage<?>> {
    public <U> void emit(@Nonnull Predicate<SubscriptionQueryMessage<?, ?, U>> var1, @Nonnull SubscriptionQueryUpdateMessage<U> var2);

    default public <U> void emit(@Nonnull Predicate<SubscriptionQueryMessage<?, ?, U>> filter, @Nullable U update) {
        if (update != null) {
            this.emit(filter, (U)QueryUpdateEmitter.asUpdateMessage(update));
        }
    }

    @Deprecated
    private static <U> SubscriptionQueryUpdateMessage<U> asUpdateMessage(Object payload) {
        if (payload instanceof SubscriptionQueryUpdateMessage) {
            return (SubscriptionQueryUpdateMessage)payload;
        }
        if (payload instanceof ResultMessage) {
            ResultMessage resultMessage = (ResultMessage)payload;
            if (resultMessage.isExceptional()) {
                Throwable cause = resultMessage.exceptionResult();
                return new GenericSubscriptionQueryUpdateMessage(new MessageType(cause.getClass()), cause, (Map<String, ?>)resultMessage.getMetaData(), resultMessage.getPayloadType());
            }
            return new GenericSubscriptionQueryUpdateMessage(resultMessage);
        }
        if (payload instanceof Message) {
            return new GenericSubscriptionQueryUpdateMessage((Message)payload);
        }
        return new GenericSubscriptionQueryUpdateMessage<Object>(new MessageType(payload.getClass()), payload);
    }

    default public <Q, U> void emit(@Nonnull Class<Q> queryType, @Nonnull Predicate<? super Q> filter, @Nonnull SubscriptionQueryUpdateMessage<U> update) {
        Predicate<SubscriptionQueryMessage<?, ?, U>> sqmFilter = m -> queryType.isAssignableFrom(m.getPayloadType()) && filter.test((Object)m.getPayload());
        this.emit(sqmFilter, (U)update);
    }

    default public <Q, U> void emit(@Nonnull Class<Q> queryType, @Nonnull Predicate<? super Q> filter, @Nullable U update) {
        if (update != null) {
            this.emit(queryType, filter, (U)QueryUpdateEmitter.asUpdateMessage(update));
        }
    }

    public void complete(@Nonnull Predicate<SubscriptionQueryMessage<?, ?, ?>> var1);

    default public <Q> void complete(@Nonnull Class<Q> queryType, @Nonnull Predicate<? super Q> filter) {
        Predicate<SubscriptionQueryMessage<?, ?, ?>> sqmFilter = m -> queryType.isAssignableFrom(m.getPayloadType()) && filter.test((Object)m.getPayload());
        this.complete(sqmFilter);
    }

    public void completeExceptionally(@Nonnull Predicate<SubscriptionQueryMessage<?, ?, ?>> var1, @Nonnull Throwable var2);

    default public <Q> void completeExceptionally(@Nonnull Class<Q> queryType, @Nonnull Predicate<? super Q> filter, @Nonnull Throwable cause) {
        Predicate<SubscriptionQueryMessage<?, ?, ?>> sqmFilter = m -> queryType.isAssignableFrom(m.getPayloadType()) && filter.test((Object)m.getPayload());
        this.completeExceptionally(sqmFilter, cause);
    }

    public boolean queryUpdateHandlerRegistered(@Nonnull SubscriptionQueryMessage<?, ?, ?> var1);

    public <U> UpdateHandlerRegistration<U> registerUpdateHandler(@Nonnull SubscriptionQueryMessage<?, ?, ?> var1, int var2);

    default public Set<SubscriptionQueryMessage<?, ?, ?>> activeSubscriptions() {
        return Collections.emptySet();
    }
}

