/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.util.Optional;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public interface MessageHandlingMember<T> {
    public Class<?> payloadType();

    default public int priority() {
        return 0;
    }

    public boolean canHandle(@Nonnull Message<?> var1, @Nullable ProcessingContext var2);

    default public boolean canHandleType(@Nonnull Class<?> payloadType) {
        return true;
    }

    public boolean canHandleMessageType(@Nonnull Class<? extends Message> var1);

    @Deprecated
    public Object handleSync(@Nonnull Message<?> var1, @Nullable T var2) throws Exception;

    default public MessageStream<?> handle(@Nonnull Message<?> message, @Nonnull ProcessingContext processingContext, @Nullable T target) {
        try {
            Object result = this.handleSync(message, target);
            return MessageStream.just(new GenericMessage<Object>(new MessageType(result.getClass()), result));
        }
        catch (Exception e) {
            return MessageStream.failed(e);
        }
    }

    public <HT> Optional<HT> unwrap(Class<HT> var1);

    default public Class<?> declaringClass() {
        return this.unwrap(Member.class).map(Member::getDeclaringClass).orElseThrow(() -> new UnsupportedOperationException("This implementation of MessageHandlingMember does not wrap a java.lang.reflect.Member. Please provide a different way of getting 'declaringClass' of this MessageHandlingMember."));
    }

    default public String signature() {
        return this.unwrap(Executable.class).map(Executable::toGenericString).orElse("__unknown__");
    }

    default public <R> Optional<R> attribute(String attributeKey) {
        return Optional.empty();
    }
}

