/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.axonframework.common.Priority;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.messaging.unitofwork.ResourceOverridingProcessingContext;

@Priority(value=0x7FFFFFFF)
public class InterceptorChainParameterResolverFactory
implements ParameterResolverFactory,
ParameterResolver<InterceptorChain> {
    private static final ThreadLocal<InterceptorChain<?, ?>> CURRENT = new ThreadLocal();
    private static final Context.ResourceKey<InterceptorChain<?, ?>> INTERCEPTOR_CHAIN_KEY = Context.ResourceKey.withLabel("InterceptorChain");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R callWithInterceptorChainSync(InterceptorChain interceptorChain, Callable<R> action) throws Exception {
        InterceptorChain<?, ?> previous = CURRENT.get();
        CURRENT.set(interceptorChain);
        try {
            R r = action.call();
            return r;
        }
        finally {
            if (previous == null) {
                CURRENT.remove();
            } else {
                CURRENT.set(previous);
            }
        }
    }

    public static <M extends Message<?>, T extends Message<?>> MessageStream<? extends T> callWithInterceptorChain(ProcessingContext processingContext, InterceptorChain<M, T> interceptorChain, Function<ProcessingContext, MessageStream<? extends T>> action) {
        ResourceOverridingProcessingContext<InterceptorChain<M, T>> newProcessingContext = new ResourceOverridingProcessingContext<InterceptorChain<M, T>>(processingContext, INTERCEPTOR_CHAIN_KEY, interceptorChain);
        return action.apply(newProcessingContext);
    }

    public static InterceptorChain currentInterceptorChain() {
        return CURRENT.get();
    }

    public static <M extends Message<?>, R extends Message<?>> InterceptorChain<M, R> currentInterceptorChain(ProcessingContext processingContext) {
        return processingContext.getResource(INTERCEPTOR_CHAIN_KEY);
    }

    @Override
    public InterceptorChain resolveParameterValue(Message<?> message, ProcessingContext processingContext) {
        InterceptorChain<?, ?> interceptorChain;
        InterceptorChain<?, ?> interceptorChain2 = interceptorChain = processingContext == null ? null : processingContext.getResource(INTERCEPTOR_CHAIN_KEY);
        if (interceptorChain == null) {
            interceptorChain = CURRENT.get();
        }
        if (interceptorChain != null) {
            return interceptorChain;
        }
        throw new IllegalStateException("InterceptorChain should have been injected");
    }

    @Override
    public boolean matches(Message<?> message, ProcessingContext processingContext) {
        return CURRENT.get() != null || processingContext != null && processingContext.containsResource(INTERCEPTOR_CHAIN_KEY);
    }

    @Override
    public ParameterResolver<InterceptorChain> createInstance(Executable executable, Parameter[] parameters, int parameterIndex) {
        if (InterceptorChain.class.equals(parameters[parameterIndex].getType())) {
            return this;
        }
        return null;
    }
}

