/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.function.Consumer;
import org.axonframework.messaging.DelegatingMessageStream;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;

class OnNextMessageStream<M extends Message<?>>
extends DelegatingMessageStream<M, M> {
    private final MessageStream<M> delegate;
    private final Consumer<MessageStream.Entry<M>> onNext;

    OnNextMessageStream(@Nonnull MessageStream<M> delegate, @Nonnull Consumer<MessageStream.Entry<M>> onNext) {
        super(delegate);
        this.delegate = delegate;
        this.onNext = onNext;
    }

    @Override
    public Optional<MessageStream.Entry<M>> next() {
        Optional<MessageStream.Entry<M>> next = this.delegate.next();
        next.ifPresent(this.onNext);
        return next;
    }

    static class Single<M extends Message<?>>
    extends OnNextMessageStream<M>
    implements MessageStream.Single<M> {
        Single(@Nonnull MessageStream.Single<M> delegate, @Nonnull Consumer<MessageStream.Entry<M>> onNext) {
            super(delegate, onNext);
        }
    }
}

