/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import org.axonframework.messaging.DelegatingMessageStream;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import reactor.core.publisher.Flux;

class CompletionCallbackMessageStream<M extends Message<?>>
extends DelegatingMessageStream<M, M> {
    private final MessageStream<M> delegate;
    private final Runnable completeHandler;
    private final AtomicBoolean invoked = new AtomicBoolean(false);

    CompletionCallbackMessageStream(@Nonnull MessageStream<M> delegate, @Nonnull Runnable completeHandler) {
        super(delegate);
        this.delegate = delegate;
        this.completeHandler = completeHandler;
        delegate.onAvailable(this::invokeOnCompleted);
    }

    @Override
    public Flux<MessageStream.Entry<M>> asFlux() {
        return this.delegate.asFlux().doOnComplete(this.completeHandler);
    }

    @Override
    public Optional<MessageStream.Entry<M>> next() {
        Optional<MessageStream.Entry<M>> next = this.delegate.next();
        if (next.isEmpty()) {
            this.invokeOnCompleted();
        }
        return next;
    }

    private void invokeOnCompleted() {
        if (this.delegate.isCompleted() && this.delegate.error().isEmpty() && !this.invoked.getAndSet(true)) {
            this.completeHandler.run();
        }
    }

    @Override
    public void onAvailable(@Nonnull Runnable callback) {
        this.delegate.onAvailable(() -> {
            callback.run();
            this.invokeOnCompleted();
        });
    }

    @Override
    public Optional<Throwable> error() {
        this.invokeOnCompleted();
        return this.delegate.error();
    }

    @Override
    public boolean hasNextAvailable() {
        boolean b = this.delegate.hasNextAvailable();
        if (!b && this.delegate().isCompleted()) {
            this.invokeOnCompleted();
        }
        return b;
    }

    @Override
    public <R> CompletableFuture<R> reduce(@Nonnull R identity, @Nonnull BiFunction<R, MessageStream.Entry<M>, R> accumulator) {
        return this.delegate.reduce(identity, accumulator).whenComplete((T result, U exception) -> {
            if (exception == null) {
                this.completeHandler.run();
            }
        });
    }

    static class Empty<M extends Message<?>>
    extends CompletionCallbackMessageStream<M>
    implements MessageStream.Empty<M> {
        Empty(@Nonnull MessageStream.Empty<M> delegate, @Nonnull Runnable completeHandler) {
            super(delegate, completeHandler);
        }
    }

    static class Single<M extends Message<?>>
    extends CompletionCallbackMessageStream<M>
    implements MessageStream.Single<M> {
        Single(@Nonnull MessageStream.Single<M> delegate, @Nonnull Runnable completeHandler) {
            super(delegate, completeHandler);
        }
    }
}

