/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.tokenstore.inmemory;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.axonframework.common.ObjectUtils;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.UnableToClaimTokenException;
import org.axonframework.eventhandling.tokenstore.UnableToInitializeTokenException;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryTokenStore
implements TokenStore {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final GlobalSequenceTrackingToken NULL_TOKEN = new GlobalSequenceTrackingToken(-1L);
    private final Map<ProcessAndSegment, TrackingToken> tokens = new ConcurrentHashMap<ProcessAndSegment, TrackingToken>();
    private final String identifier = UUID.randomUUID().toString();

    public InMemoryTokenStore() {
        logger.warn("An in memory token store is being created.\nThis means the event processor using this token store might process the same events again when the application is restarted.\nIf the use of an in memory token store is intentional, this warning can be ignored.\nIf the tokens should be persisted, use the JPA, JDBC or MongoDB token store instead.");
    }

    @Override
    public void initializeTokenSegments(@Nonnull String processorName, int segmentCount) throws UnableToClaimTokenException {
        this.initializeTokenSegments(processorName, segmentCount, null);
    }

    @Override
    public void initializeTokenSegments(@Nonnull String processorName, int segmentCount, TrackingToken initialToken) throws UnableToClaimTokenException {
        if (this.fetchSegments(processorName).length > 0) {
            throw new UnableToClaimTokenException("Could not initialize segments. Some segments were already present.");
        }
        for (int segment = 0; segment < segmentCount; ++segment) {
            this.tokens.put(new ProcessAndSegment(processorName, segment), ObjectUtils.getOrDefault(initialToken, NULL_TOKEN));
        }
    }

    @Override
    public void storeToken(TrackingToken token, @Nonnull String processorName, int segment) {
        if (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().afterCommit(uow -> this.tokens.put(new ProcessAndSegment(processorName, segment), ObjectUtils.getOrDefault(token, NULL_TOKEN)));
        } else {
            this.tokens.put(new ProcessAndSegment(processorName, segment), ObjectUtils.getOrDefault(token, NULL_TOKEN));
        }
    }

    @Override
    public TrackingToken fetchToken(@Nonnull String processorName, int segment) {
        TrackingToken trackingToken = this.tokens.get(new ProcessAndSegment(processorName, segment));
        if (trackingToken == null) {
            throw new UnableToClaimTokenException("No token was initialized for segment " + segment + " for processor " + processorName);
        }
        if (NULL_TOKEN == trackingToken) {
            return null;
        }
        return trackingToken;
    }

    @Override
    public void releaseClaim(@Nonnull String processorName, int segment) {
    }

    @Override
    public void deleteToken(@Nonnull String processorName, int segment) throws UnableToClaimTokenException {
        this.tokens.remove(new ProcessAndSegment(processorName, segment));
    }

    @Override
    public void initializeSegment(TrackingToken token, @Nonnull String processorName, int segment) throws UnableToInitializeTokenException {
        TrackingToken previous = this.tokens.putIfAbsent(new ProcessAndSegment(processorName, segment), token == null ? NULL_TOKEN : token);
        if (previous != null) {
            throw new UnableToInitializeTokenException("Token was already present");
        }
    }

    @Override
    public boolean requiresExplicitSegmentInitialization() {
        return true;
    }

    @Override
    public int[] fetchSegments(@Nonnull String processorName) {
        return this.tokens.keySet().stream().filter(ps -> ps.processorName.equals(processorName)).map(ProcessAndSegment::getSegment).distinct().mapToInt(Number::intValue).sorted().toArray();
    }

    @Override
    public Optional<String> retrieveStorageIdentifier() {
        return Optional.of(this.identifier);
    }

    private static class ProcessAndSegment {
        private final String processorName;
        private final int segment;

        public ProcessAndSegment(String processorName, int segment) {
            this.processorName = processorName;
            this.segment = segment;
        }

        public int getSegment() {
            return this.segment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcessAndSegment that = (ProcessAndSegment)o;
            return this.segment == that.segment && Objects.equals(this.processorName, that.processorName);
        }

        public int hashCode() {
            return Objects.hash(this.processorName, this.segment);
        }
    }
}

