/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.replay;

import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.ReplayToken;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.replay.ReplayContext;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class ReplayContextParameterResolverFactory
implements ParameterResolverFactory {
    @Override
    public ParameterResolver createInstance(Executable executable, Parameter[] parameters, int parameterIndex) {
        Parameter parameter = parameters[parameterIndex];
        if (parameter.isAnnotationPresent(ReplayContext.class)) {
            return new ReplayContextParameterResolver(parameter.getType());
        }
        return null;
    }

    private static class ReplayContextParameterResolver
    implements ParameterResolver<Object> {
        private final Class<?> type;

        public ReplayContextParameterResolver(Class<?> type) {
            this.type = type;
        }

        @Override
        public Object resolveParameterValue(Message message, ProcessingContext processingContext) {
            return ReplayToken.replayContext((EventMessage)message, this.type).orElse(null);
        }

        @Override
        public boolean matches(Message message, ProcessingContext processingContext) {
            return message instanceof TrackedEventMessage;
        }
    }
}

