/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventMessageHandler;
import org.axonframework.messaging.DefaultInterceptorChain;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.Decisions;
import org.axonframework.messaging.deadletter.EnqueueDecision;
import org.axonframework.messaging.deadletter.EnqueuePolicy;
import org.axonframework.messaging.unitofwork.LegacyDefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.LegacyUnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeadLetteredEventProcessingTask
implements Function<DeadLetter<EventMessage<?>>, EnqueueDecision<EventMessage<?>>> {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<EventMessageHandler> eventHandlingComponents;
    private final List<MessageHandlerInterceptor<? super EventMessage<?>>> interceptors;
    private final EnqueuePolicy<EventMessage<?>> enqueuePolicy;
    private final TransactionManager transactionManager;

    DeadLetteredEventProcessingTask(List<EventMessageHandler> eventHandlingComponents, List<MessageHandlerInterceptor<? super EventMessage<?>>> interceptors, EnqueuePolicy<EventMessage<?>> enqueuePolicy, TransactionManager transactionManager) {
        this.eventHandlingComponents = eventHandlingComponents;
        this.interceptors = interceptors;
        this.enqueuePolicy = enqueuePolicy;
        this.transactionManager = transactionManager;
    }

    @Override
    public EnqueueDecision<EventMessage<?>> apply(DeadLetter<EventMessage<?>> letter) {
        return this.process(letter);
    }

    public EnqueueDecision<EventMessage<?>> process(DeadLetter<? extends EventMessage<?>> letter) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Start evaluation of dead letter with message id [{}].", (Object)letter.message().getIdentifier());
        }
        AtomicReference decision = new AtomicReference();
        LegacyDefaultUnitOfWork<EventMessage<?>> unitOfWork = LegacyDefaultUnitOfWork.startAndGet(letter.message());
        unitOfWork.attachTransaction(this.transactionManager);
        unitOfWork.resources().put(DeadLetter.class.getName(), letter);
        unitOfWork.onPrepareCommit(uow -> decision.set(this.onCommit(letter)));
        unitOfWork.onRollback(uow -> decision.set(this.onRollback(letter, uow.getExecutionResult().getExceptionResult())));
        unitOfWork.executeWithResult(() -> this.handleWithInterceptors(unitOfWork));
        return (EnqueueDecision)((Object)ObjectUtils.getOrDefault((EnqueueDecision)decision.get(), Decisions::ignore));
    }

    private void handle(EventMessage<?> eventMessage) throws Exception {
        for (EventMessageHandler handler : this.eventHandlingComponents) {
            handler.handleSync(eventMessage);
        }
    }

    private Object handleWithInterceptors(LegacyUnitOfWork<? extends EventMessage<?>> unitOfWork) throws Exception {
        new DefaultInterceptorChain(unitOfWork, this.interceptors, m -> {
            this.handle((EventMessage<?>)m);
            return null;
        }).proceedSync();
        return null;
    }

    private EnqueueDecision<EventMessage<?>> onCommit(DeadLetter<? extends EventMessage<?>> letter) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Processing dead letter with message id [{}] was successful.", (Object)letter.message().getIdentifier());
        }
        return Decisions.evict();
    }

    private EnqueueDecision<EventMessage<?>> onRollback(DeadLetter<? extends EventMessage<?>> letter, Throwable cause) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Processing dead letter with message id [{}] failed.", (Object)letter.message().getIdentifier(), (Object)cause);
        }
        return this.enqueuePolicy.decide(letter, cause);
    }
}

