/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.Map;
import java.util.function.Supplier;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MetaData;

public class GenericDomainEventMessage<P>
extends GenericEventMessage<P>
implements DomainEventMessage<P> {
    private final String aggregateType;
    private final String aggregateIdentifier;
    private final long sequenceNumber;

    public GenericDomainEventMessage(String aggregateType, String aggregateIdentifier, long sequenceNumber, @Nonnull MessageType type, @Nonnull P payload) {
        this(aggregateType, aggregateIdentifier, sequenceNumber, type, payload, MetaData.emptyInstance());
    }

    public GenericDomainEventMessage(String aggregateType, String aggregateIdentifier, long sequenceNumber, @Nonnull MessageType type, @Nonnull P payload, @Nonnull Map<String, ?> metaData) {
        this(aggregateType, aggregateIdentifier, sequenceNumber, new GenericMessage<P>(type, payload, metaData), clock.instant());
    }

    public GenericDomainEventMessage(String aggregateType, String aggregateIdentifier, long sequenceNumber, @Nonnull String messageIdentifier, @Nonnull MessageType type, @Nonnull P payload, @Nonnull Map<String, ?> metaData, @Nonnull Instant timestamp) {
        this(aggregateType, aggregateIdentifier, sequenceNumber, new GenericMessage<P>(messageIdentifier, type, payload, metaData), timestamp);
    }

    public GenericDomainEventMessage(String aggregateType, String aggregateIdentifier, long sequenceNumber, @Nonnull Message<P> delegate, @Nonnull Supplier<Instant> timestampSupplier) {
        super(delegate, timestampSupplier);
        this.aggregateType = aggregateType;
        this.aggregateIdentifier = aggregateIdentifier;
        this.sequenceNumber = sequenceNumber;
    }

    public GenericDomainEventMessage(String aggregateType, String aggregateIdentifier, long sequenceNumber, @Nonnull Message<P> delegate, @Nonnull Instant timestamp) {
        super(delegate, timestamp);
        this.aggregateType = aggregateType;
        this.aggregateIdentifier = aggregateIdentifier;
        this.sequenceNumber = sequenceNumber;
    }

    @Override
    public String getType() {
        return this.aggregateType;
    }

    @Override
    public String getAggregateIdentifier() {
        return this.aggregateIdentifier;
    }

    @Override
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public GenericDomainEventMessage<P> withMetaData(@Nonnull Map<String, ?> metaData) {
        if (this.getMetaData().equals(metaData)) {
            return this;
        }
        return new GenericDomainEventMessage(this.aggregateType, this.aggregateIdentifier, this.sequenceNumber, this.getDelegate().withMetaData(metaData), this.getTimestamp());
    }

    @Override
    public GenericDomainEventMessage<P> andMetaData(@Nonnull Map<String, ?> metaData) {
        if (metaData == null || metaData.isEmpty() || this.getMetaData().equals(metaData)) {
            return this;
        }
        return new GenericDomainEventMessage(this.aggregateType, this.aggregateIdentifier, this.sequenceNumber, this.getDelegate().andMetaData(metaData), this.getTimestamp());
    }

    @Override
    protected void describeTo(StringBuilder stringBuilder) {
        super.describeTo(stringBuilder);
        stringBuilder.append('\'').append(", aggregateType='").append(this.getType()).append('\'').append(", aggregateIdentifier='").append(this.getAggregateIdentifier()).append('\'').append(", sequenceNumber=").append(this.getSequenceNumber());
    }

    @Override
    protected String describeType() {
        return "GenericDomainEventMessage";
    }
}

