/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.axonframework.messaging.Message;

public interface EventMessage<P>
extends Message<P> {
    @Override
    public String getIdentifier();

    public Instant getTimestamp();

    @Override
    public EventMessage<P> withMetaData(@Nonnull Map<String, ?> var1);

    @Override
    public EventMessage<P> andMetaData(@Nonnull Map<String, ?> var1);

    @Override
    default public <C> EventMessage<C> withConvertedPayload(@Nonnull Function<P, C> conversion) {
        Object payload = this.getPayload();
        if (Objects.equals(payload, conversion.apply(payload))) {
            return this;
        }
        throw new UnsupportedOperationException("To be implemented");
    }
}

